/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.mybatisplus;

import cn.woodwhales.common.business.DataTool;
import cn.woodwhales.common.model.field.PageQueryInterface;
import cn.woodwhales.common.model.vo.PageRespVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;

public class MybatisPlusExecutor {
    public static <Entity, Mapper extends BaseMapper<Entity>, DTO> List<DTO> executeQueryList(Mapper mapper, Wrapper<Entity> wrapper, Function<? super Entity, ? extends DTO> mapping) {
        List entityList = mapper.selectList(wrapper);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return new ArrayList();
        }
        return DataTool.toList(entityList, mapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO> List<DTO> executeQueryList(Mapper mapper, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer, Function<? super Entity, ? extends DTO> mapping) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        return MybatisPlusExecutor.executeQueryList(mapper, wrapper, mapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> List<Entity> executeQueryList(Mapper mapper, Wrapper<Entity> wrapper) {
        List entityList = mapper.selectList(wrapper);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return new ArrayList();
        }
        return entityList;
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> List<Entity> executeQueryList(Mapper mapper, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapperConsumer.accept(wrapper);
        return MybatisPlusExecutor.executeQueryList(mapper, wrapper);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO, Key> Map<Key, DTO> executeQueryListMap(Mapper mapper, Wrapper<Entity> wrapper, Function<? super Entity, ? extends DTO> mapping, Function<? super DTO, ? extends Key> keyMapping) {
        return DataTool.toMap(MybatisPlusExecutor.executeQueryList(mapper, wrapper, mapping), keyMapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO, Key> Map<Key, DTO> executeQueryListMap(Mapper mapper, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer, Function<? super Entity, ? extends DTO> mapping, Function<? super DTO, ? extends Key> keyMapping) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapperConsumer.accept(wrapper);
        return DataTool.toMap(MybatisPlusExecutor.executeQueryList(mapper, wrapper, mapping), keyMapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO> DTO executeQueryOne(Mapper mapper, Wrapper<Entity> wrapper, Function<? super Entity, ? extends DTO> mapping) {
        Object entity = mapper.selectOne(wrapper);
        if (Objects.isNull(entity)) {
            return null;
        }
        return mapping.apply(entity);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>, DTO> DTO executeQueryOne(Mapper mapper, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer, Function<? super Entity, ? extends DTO> mapping) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapperConsumer.accept(wrapper);
        return MybatisPlusExecutor.executeQueryOne(mapper, lambdaQueryWrapperConsumer, mapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> Entity executeQueryOne(Mapper mapper, Wrapper<Entity> wrapper) {
        Object entity = mapper.selectOne(wrapper);
        if (Objects.isNull(entity)) {
            return null;
        }
        return (Entity)entity;
    }

    public static <Entity, DTO, Mapper extends BaseMapper<Entity>> PageRespVO<DTO> executeQueryPage(Mapper mapper, PageQueryInterface queryParam, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer, Function<Entity, DTO> mapping) {
        IPage<Entity> pageResult = MybatisPlusExecutor.executeSelectPage(mapper, queryParam, lambdaQueryWrapperConsumer);
        return PageRespVO.buildPageRespVO(pageResult, mapping);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> PageRespVO<Entity> executeQueryPage(Mapper mapper, PageQueryInterface queryParam, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer) {
        IPage<Entity> pageResult = MybatisPlusExecutor.executeSelectPage(mapper, queryParam, lambdaQueryWrapperConsumer);
        return PageRespVO.buildPageRespVO(pageResult);
    }

    public static <Entity, Mapper extends BaseMapper<Entity>> PageRespVO<Entity> executeQueryPage(Mapper mapper, PageQueryInterface queryParam, Wrapper<Entity> wrapper) {
        Page page = new Page((long)queryParam.getPage().intValue(), (long)queryParam.getLimit().intValue());
        IPage pageResult = mapper.selectPage((IPage)page, wrapper);
        return PageRespVO.buildPageRespVO(pageResult);
    }

    private static <Entity, Mapper extends BaseMapper<Entity>> IPage<Entity> executeSelectPage(Mapper mapper, PageQueryInterface queryParam, Consumer<LambdaQueryWrapper<Entity>> lambdaQueryWrapperConsumer) {
        Page page = new Page((long)queryParam.getPage().intValue(), (long)queryParam.getLimit().intValue());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapperConsumer.accept(wrapper);
        return mapper.selectPage((IPage)page, (Wrapper)wrapper);
    }

    public static <Mapper extends BaseMapper<Entity>, Entity> boolean batchInsert(ServiceImpl<Mapper, Entity> batchMapper, List<Entity> entityList) {
        if (CollectionUtils.isEmpty(entityList)) {
            return true;
        }
        return batchMapper.saveBatch(entityList);
    }

    public static <Mapper extends BaseMapper<Entity>, Entity, DTO> boolean batchInsert(ServiceImpl<Mapper, Entity> batchMapper, Function<List<DTO>, List<Entity>> mapping, List<DTO> dtoList) {
        return batchMapper.saveBatch((Collection)mapping.apply(dtoList));
    }

    public static <Mapper extends BaseMapper<Entity>, Entity, K extends Serializable> int update(Mapper mapper, Entity entity, Function<Entity, K> entityIdFunction, Function<Entity, Entity> function) {
        Object entityFromDB = mapper.selectById((Serializable)entityIdFunction.apply(entity));
        if (Objects.isNull(entityFromDB)) {
            return 0;
        }
        return mapper.updateById(function.apply(entityFromDB));
    }
}

