/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.business.tree;

import cn.woodwhales.common.business.tree.TreeNode;
import cn.woodwhales.common.business.tree.TreeNodeAttributeMapper;
import cn.woodwhales.common.business.tree.TreeNodeGenerator;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class TreeTool {
    public static <K, T> List<Map<String, Object>> tree(List<T> sourceList, TreeNodeGenerator<K, T> treeNodeGenerator, TreeNodeAttributeMapper<T> treeNodeAttributeMapper) {
        return TreeTool.tree(sourceList, treeNodeGenerator, treeNodeAttributeMapper, false);
    }

    public static <K, T> List<Map<String, Object>> tree(List<T> sourceList, TreeNodeGenerator<K, T> treeNodeGenerator, TreeNodeAttributeMapper<T> treeNodeAttributeMapper, Function<T, Object> extraFunction) {
        return TreeTool.tree(sourceList, treeNodeGenerator, treeNodeAttributeMapper, null, false);
    }

    public static <K, T> List<Map<String, Object>> tree(List<T> sourceList, TreeNodeGenerator<K, T> treeNodeGenerator, TreeNodeAttributeMapper<T> treeNodeAttributeMapper, Function<T, Object> extraFunction, boolean withData) {
        Function<T, Object> overNodeIdFunction = treeNodeAttributeMapper.getOverNodeIdFunction();
        if ((Objects.nonNull(overNodeIdFunction) || Objects.nonNull(extraFunction)) && !withData) {
            return TreeTool.tree(sourceList, treeNodeGenerator, treeNodeAttributeMapper, extraFunction, true, true);
        }
        return TreeTool.tree(sourceList, treeNodeGenerator, treeNodeAttributeMapper, extraFunction, withData, !withData);
    }

    private static <K, T> List<Map<String, Object>> tree(List<T> sourceList, TreeNodeGenerator<K, T> treeNodeGenerator, TreeNodeAttributeMapper<T> treeNodeAttributeMapper, Function<T, Object> extraFunction, boolean withData, boolean needDropData) {
        Preconditions.checkNotNull(treeNodeAttributeMapper, (Object)"treeNodeAttributeMapper must not null");
        List<TreeNode<K, T>> treeNodeList = TreeTool.tree(sourceList, treeNodeGenerator, withData);
        return treeNodeList.stream().map(treeNode -> TreeNode.toMap(treeNode, treeNodeAttributeMapper, extraFunction, withData, needDropData)).collect(Collectors.toList());
    }

    public static <K, T> List<Map<String, Object>> tree(List<T> sourceList, TreeNodeGenerator<K, T> treeNodeGenerator, TreeNodeAttributeMapper<T> treeNodeAttributeMapper, boolean withData) {
        return TreeTool.tree(sourceList, treeNodeGenerator, treeNodeAttributeMapper, null, withData);
    }

    public static <K, T> List<TreeNode<K, T>> tree(List<T> sourceList, TreeNodeGenerator<K, T> treeNodeGenerator) {
        return TreeTool.tree(sourceList, treeNodeGenerator, false);
    }

    public static <K, T> List<TreeNode<K, T>> tree(List<T> sourceList, TreeNodeGenerator<K, T> treeNodeGenerator, boolean withData) {
        Preconditions.checkNotNull(treeNodeGenerator, (Object)"treeNodeGenerator must not null");
        if (CollectionUtils.isEmpty(sourceList)) {
            return Collections.emptyList();
        }
        List<TreeNode<K, T>> rootNodeList = sourceList.stream().filter(treeNodeGenerator::isRootNode).map(source -> TreeNode.build(source, treeNodeGenerator, withData)).sorted(Comparator.comparing(TreeNode::getSort)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(rootNodeList)) {
            return Collections.emptyList();
        }
        Map<Object, List<TreeNode>> unRootNodeContainer = sourceList.stream().filter(source -> !treeNodeGenerator.isRootNode(source)).map(source -> TreeNode.build(source, treeNodeGenerator, withData)).sorted(Comparator.comparing(TreeNode::getSort)).collect(Collectors.groupingBy(TreeNode::getParentId));
        for (TreeNode treeNode : rootNodeList) {
            treeNode.setChildren(TreeTool.buildChildren(treeNode.getId(), unRootNodeContainer));
        }
        return rootNodeList;
    }

    private static <K, T> List<TreeNode<K, T>> buildChildren(K currentNodeId, Map<K, List<TreeNode<K, T>>> unRootNodeContainer) {
        List<TreeNode<K, T>> childrenList = unRootNodeContainer.get(currentNodeId);
        if (CollectionUtils.isEmpty(childrenList)) {
            return null;
        }
        for (TreeNode<K, T> treeNode : childrenList) {
            treeNode.setChildren(TreeTool.buildChildren(treeNode.getId(), unRootNodeContainer));
        }
        return childrenList;
    }
}

