/*
 * Decompiled with CFR 0.152.
 */
package cn.woodwhales.common.business.chinese;

import cn.woodwhales.common.business.chinese.ChineseDataTool;
import cn.woodwhales.common.business.chinese.ChineseInterface;
import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class ChineseDataContainer<T> {
    private T data;
    private String field;

    public ChineseDataContainer(T data, ChineseInterface<T> chineseInterface) {
        this.data = data;
        this.field = chineseInterface.getSortedField(data);
    }

    public static <T> List<ChineseDataContainer<T>> build(List<T> dataList, ChineseInterface<T> chineseInterface) {
        if (CollectionUtils.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        ArrayList<ChineseDataContainer<T>> list = new ArrayList<ChineseDataContainer<T>>(dataList.size());
        for (T data : dataList) {
            list.add(new ChineseDataContainer<T>(data, chineseInterface));
        }
        return list;
    }

    public int compare(ChineseDataContainer chineseDataContainer) {
        return ComparisonChain.start().compare((Object)this.field, (Object)chineseDataContainer.getField(), (Comparator)ChineseDataTool.collator).result();
    }

    public T getData() {
        return this.data;
    }

    public String getField() {
        return this.field;
    }
}

