/*
 * Decompiled with CFR 0.152.
 */
package cn.woblog.android.downloader.domain;

import android.text.TextUtils;
import cn.woblog.android.downloader.callback.DownloadListener;
import cn.woblog.android.downloader.domain.DownloadThreadInfo;
import cn.woblog.android.downloader.exception.DownloadException;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class DownloadInfo
implements Serializable {
    public static final int STATUS_NONE = 0;
    public static final int STATUS_PREPARE_DOWNLOAD = 1;
    public static final int STATUS_DOWNLOADING = 2;
    public static final int STATUS_WAIT = 3;
    public static final int STATUS_PAUSED = 4;
    public static final int STATUS_COMPLETED = 5;
    public static final int STATUS_ERROR = 6;
    public static final int STATUS_REMOVED = 7;
    private int id;
    private int supportRanges;
    private long createAt;
    private String uri;
    private String path;
    private long size;
    private long progress;
    private int status;
    private List<DownloadThreadInfo> downloadThreadInfos;
    private transient DownloadListener downloadListener;
    private DownloadException exception;

    public DownloadException getException() {
        return this.exception;
    }

    public void setException(DownloadException exception) {
        this.exception = exception;
    }

    public long getCreateAt() {
        return this.createAt;
    }

    public void setCreateAt(long createAt) {
        this.createAt = createAt;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getProgress() {
        return this.progress;
    }

    public void setProgress(long progress) {
        this.progress = progress;
    }

    public DownloadListener getDownloadListener() {
        return this.downloadListener;
    }

    public void setDownloadListener(DownloadListener downloadListener) {
        this.downloadListener = downloadListener;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getSupportRanges() {
        return this.supportRanges;
    }

    public void setSupportRanges(int supportRanges) {
        this.supportRanges = supportRanges;
    }

    public boolean isSupportRanges() {
        return this.supportRanges == 0;
    }

    public void setSupportRanges(boolean supportRanges) {
        this.supportRanges = supportRanges ? 0 : 1;
    }

    public List<DownloadThreadInfo> getDownloadThreadInfos() {
        return this.downloadThreadInfos;
    }

    public void setDownloadThreadInfos(List<DownloadThreadInfo> downloadThreadInfos) {
        this.downloadThreadInfos = downloadThreadInfos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadInfo downloadInfo = (DownloadInfo)o;
        return this.id == downloadInfo.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isPause() {
        return this.status == 4 || this.status == 6 || this.status == 7;
    }

    public static final class Builder {
        private static final String DEFAULT_ENCODE = "utf-8";
        private String id;
        private long createAt = -1L;
        private String url;
        private String path;

        public Builder setCreateAt(long createAt) {
            this.createAt = createAt;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public void setId(String id) {
            this.id = id;
        }

        public DownloadInfo build() {
            DownloadInfo downloadInfo = new DownloadInfo();
            if (TextUtils.isEmpty((CharSequence)this.url)) {
                throw new DownloadException(0, "uri cannot be null.");
            }
            downloadInfo.setUri(this.url);
            if (TextUtils.isEmpty((CharSequence)this.path)) {
                throw new DownloadException(1, "path cannot be null.");
            }
            downloadInfo.setPath(this.path);
            if (this.createAt == -1L) {
                this.setCreateAt(System.currentTimeMillis());
            }
            downloadInfo.setId(this.url.hashCode());
            if (TextUtils.isEmpty((CharSequence)this.id)) {
                downloadInfo.setId(this.url.hashCode());
            }
            return downloadInfo;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DownloadStatus {
    }
}

