/*
 * Decompiled with CFR 0.152.
 */
package cn.woblog.android.downloader.db;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import cn.woblog.android.downloader.config.Config;
import cn.woblog.android.downloader.db.DefaultDownloadHelper;
import cn.woblog.android.downloader.db.DownloadDBController;
import cn.woblog.android.downloader.domain.DownloadInfo;
import cn.woblog.android.downloader.domain.DownloadThreadInfo;
import java.util.ArrayList;
import java.util.List;

public class DefaultDownloadDBController
implements DownloadDBController {
    public static final String[] DOWNLOAD_INFO_COLUMNS = new String[]{"_id", "supportRanges", "createAt", "uri", "path", "size", "progress", "status"};
    public static final String[] DOWNLOAD_THREAD_INFO_COLUMNS = new String[]{"_id", "threadId", "downloadInfoId", "uri", "start", "end", "progress"};
    public static final String SQL_UPDATE_DOWNLOAD_THREAD_INFO = String.format("REPLACE INTO %s (_id,threadId,downloadInfoId,uri,start,end,progress) VALUES(?,?,?,?,?,?,?);", "download_thread_info");
    public static final String SQL_UPDATE_DOWNLOAD_INFO = String.format("REPLACE INTO %s (_id,supportRanges,createAt,uri,path,size,progress,status) VALUES(?,?,?,?,?,?,?,?);", "download_info");
    public static final String SQL_UPDATE_DOWNLOADING_INFO_STATUS = String.format("UPDATE %s SET status=? WHERE status!=?;", "download_info");
    private final Context context;
    private final DefaultDownloadHelper dbHelper;
    private final SQLiteDatabase writableDatabase;
    private final SQLiteDatabase readableDatabase;

    public DefaultDownloadDBController(Context context, Config config) {
        this.context = context;
        this.dbHelper = new DefaultDownloadHelper(context, config);
        this.writableDatabase = this.dbHelper.getWritableDatabase();
        this.readableDatabase = this.dbHelper.getReadableDatabase();
    }

    @Override
    public List<DownloadInfo> findAllDownloading() {
        Cursor cursor = this.readableDatabase.query("download_info", DOWNLOAD_INFO_COLUMNS, "status!=?", new String[]{String.valueOf(5)}, null, null, "createAt desc");
        ArrayList<DownloadInfo> downloads = new ArrayList<DownloadInfo>();
        while (cursor.moveToNext()) {
            DownloadInfo downloadInfo = new DownloadInfo();
            downloads.add(downloadInfo);
            this.inflateDownloadInfo(cursor, downloadInfo);
            Cursor downloadCursor = this.readableDatabase.query("download_thread_info", DOWNLOAD_THREAD_INFO_COLUMNS, "downloadInfoId=?", new String[]{String.valueOf(downloadInfo.getId())}, null, null, null);
            ArrayList<DownloadThreadInfo> downloadThreads = new ArrayList<DownloadThreadInfo>();
            while (downloadCursor.moveToNext()) {
                DownloadThreadInfo downloadThreadInfo = new DownloadThreadInfo();
                downloadThreads.add(downloadThreadInfo);
                this.inflateDownloadThreadInfo(downloadCursor, downloadThreadInfo);
            }
            downloadInfo.setDownloadThreadInfos(downloadThreads);
        }
        return downloads;
    }

    @Override
    public List<DownloadInfo> findAllDownloaded() {
        Cursor cursor = this.readableDatabase.query("download_info", DOWNLOAD_INFO_COLUMNS, "status=?", new String[]{String.valueOf(5)}, null, null, "createAt desc");
        ArrayList<DownloadInfo> downloads = new ArrayList<DownloadInfo>();
        while (cursor.moveToNext()) {
            DownloadInfo downloadInfo = new DownloadInfo();
            downloads.add(downloadInfo);
            this.inflateDownloadInfo(cursor, downloadInfo);
        }
        return downloads;
    }

    private void inflateDownloadThreadInfo(Cursor cursor, DownloadThreadInfo downloadThreadInfo) {
        downloadThreadInfo.setId(cursor.getInt(0));
        downloadThreadInfo.setThreadId(cursor.getInt(1));
        downloadThreadInfo.setDownloadInfoId(cursor.getInt(2));
        downloadThreadInfo.setUri(cursor.getString(3));
        downloadThreadInfo.setStart(cursor.getLong(4));
        downloadThreadInfo.setEnd(cursor.getLong(5));
        downloadThreadInfo.setProgress(cursor.getLong(6));
    }

    private void inflateDownloadInfo(Cursor cursor, DownloadInfo downloadInfo) {
        downloadInfo.setId(cursor.getInt(0));
        downloadInfo.setSupportRanges(cursor.getInt(1));
        downloadInfo.setCreateAt(cursor.getLong(2));
        downloadInfo.setUri(cursor.getString(3));
        downloadInfo.setPath(cursor.getString(4));
        downloadInfo.setSize(cursor.getLong(5));
        downloadInfo.setProgress(cursor.getLong(6));
        downloadInfo.setStatus(cursor.getInt(7));
    }

    @Override
    public DownloadInfo findDownloadedInfoById(int id) {
        Cursor cursor = this.readableDatabase.query("download_info", DOWNLOAD_INFO_COLUMNS, "_id=?", new String[]{String.valueOf(id)}, null, null, "createAt desc");
        if (cursor.moveToNext()) {
            DownloadInfo downloadInfo = new DownloadInfo();
            this.inflateDownloadInfo(cursor, downloadInfo);
            return downloadInfo;
        }
        return null;
    }

    @Override
    public void pauseAllDownloading() {
        this.writableDatabase.execSQL(SQL_UPDATE_DOWNLOADING_INFO_STATUS, new Object[]{4, 5});
    }

    @Override
    public void createOrUpdate(DownloadInfo downloadInfo) {
        this.writableDatabase.execSQL(SQL_UPDATE_DOWNLOAD_INFO, new Object[]{downloadInfo.getId(), downloadInfo.getSupportRanges(), downloadInfo.getCreateAt(), downloadInfo.getUri(), downloadInfo.getPath(), downloadInfo.getSize(), downloadInfo.getProgress(), downloadInfo.getStatus()});
    }

    @Override
    public void createOrUpdate(DownloadThreadInfo downloadThreadInfo) {
        this.writableDatabase.execSQL(SQL_UPDATE_DOWNLOAD_THREAD_INFO, new Object[]{downloadThreadInfo.getId(), downloadThreadInfo.getThreadId(), downloadThreadInfo.getDownloadInfoId(), downloadThreadInfo.getUri(), downloadThreadInfo.getStart(), downloadThreadInfo.getEnd(), downloadThreadInfo.getProgress()});
    }

    @Override
    public void delete(DownloadInfo downloadInfo) {
        this.writableDatabase.delete("download_info", "_id=?", new String[]{String.valueOf(downloadInfo.getId())});
        this.writableDatabase.delete("download_thread_info", "downloadInfoId=?", new String[]{String.valueOf(downloadInfo.getId())});
    }

    @Override
    public void delete(DownloadThreadInfo downloadThreadInfo) {
        this.writableDatabase.delete("download_thread_info", "id=?", new String[]{String.valueOf(downloadThreadInfo.getId())});
    }
}

