/*
 * Decompiled with CFR 0.152.
 */
package cn.woblog.android.downloader.core.thread;

import android.os.Process;
import android.util.Log;
import cn.woblog.android.downloader.config.Config;
import cn.woblog.android.downloader.core.DownloadResponse;
import cn.woblog.android.downloader.domain.DownloadInfo;
import cn.woblog.android.downloader.domain.DownloadThreadInfo;
import cn.woblog.android.downloader.exception.DownloadException;
import cn.woblog.android.downloader.exception.DownloadPauseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;

public class DownloadThread
implements Runnable {
    public static final String TAG = "DownloadThread";
    private final DownloadThreadInfo downloadThreadInfo;
    private final DownloadResponse downloadResponse;
    private final Config config;
    private final DownloadInfo downloadInfo;
    private final DownloadProgressListener downloadProgressListener;
    private long lastProgress;
    private InputStream inputStream;
    private int retryDownloadCount = 0;

    public DownloadThread(DownloadThreadInfo downloadThreadInfo, DownloadResponse downloadResponse, Config config, DownloadInfo downloadInfo, DownloadProgressListener downloadProgressListener) {
        this.downloadThreadInfo = downloadThreadInfo;
        this.downloadResponse = downloadResponse;
        this.config = config;
        this.downloadInfo = downloadInfo;
        this.lastProgress = downloadThreadInfo.getProgress();
        this.downloadProgressListener = downloadProgressListener;
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        this.checkPause();
        try {
            this.executeDownload();
        }
        catch (DownloadException e) {
            this.downloadInfo.setStatus(6);
            this.downloadInfo.setException(e);
            this.downloadResponse.onStatusChanged(this.downloadInfo);
            this.downloadResponse.handleException(e);
        }
    }

    private void executeDownload() {
        HttpURLConnection httpConnection = null;
        try {
            int responseCode;
            URL url = new URL(this.downloadThreadInfo.getUri());
            httpConnection = (HttpURLConnection)url.openConnection();
            httpConnection.setConnectTimeout(this.config.getConnectTimeout());
            httpConnection.setReadTimeout(this.config.getReadTimeout());
            httpConnection.setRequestMethod(this.config.getMethod());
            long lastStart = this.downloadThreadInfo.getStart() + this.lastProgress;
            if (this.downloadInfo.isSupportRanges()) {
                httpConnection.setRequestProperty("Range", "bytes=" + lastStart + "-" + this.downloadThreadInfo.getEnd());
            }
            if ((responseCode = httpConnection.getResponseCode()) == 206 || responseCode == 200) {
                this.inputStream = httpConnection.getInputStream();
                RandomAccessFile raf = new RandomAccessFile(this.downloadInfo.getPath(), "rwd");
                raf.seek(lastStart);
                byte[] bf = new byte[4096];
                int len = -1;
                int offset = 0;
                while (true) {
                    this.checkPause();
                    len = this.inputStream.read(bf);
                    if (len == -1) break;
                    raf.write(bf, 0, len);
                    this.downloadThreadInfo.setProgress(this.lastProgress + (long)(offset += len));
                    this.downloadProgressListener.onProgress();
                    Log.d((String)TAG, (String)("downloadInfo:" + this.downloadInfo.getId() + " thread:" + this.downloadThreadInfo.getThreadId() + " progress:" + this.downloadThreadInfo.getProgress() + ",start:" + this.downloadThreadInfo.getStart() + ",end:" + this.downloadThreadInfo.getEnd()));
                }
            } else {
                throw new DownloadException(8, "UnSupported response code:" + responseCode);
            }
            this.downloadProgressListener.onDownloadSuccess();
            this.checkPause();
        }
        catch (ProtocolException e) {
            throw new DownloadException(4, "Protocol error", e);
        }
        catch (IOException e) {
            throw new DownloadException(5, "IO error", e);
        }
        catch (DownloadPauseException e) {
        }
        catch (Exception e) {
            throw new DownloadException(9, "other error", e);
        }
        finally {
            if (httpConnection != null) {
                httpConnection.disconnect();
            }
        }
    }

    private void checkPause() {
        if (this.downloadInfo.isPause()) {
            throw new DownloadPauseException(7);
        }
    }

    public static interface DownloadProgressListener {
        public void onProgress();

        public void onDownloadSuccess();
    }
}

