/*
 * Decompiled with CFR 0.152.
 */
package cn.woblog.android.downloader.core.task;

import android.os.Process;
import android.text.TextUtils;
import cn.woblog.android.downloader.core.DownloadResponse;
import cn.woblog.android.downloader.domain.DownloadInfo;
import cn.woblog.android.downloader.exception.DownloadException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

public class GetFileInfoTask
implements Runnable {
    private final DownloadResponse downloadResponse;
    private final DownloadInfo downloadInfo;
    private final OnGetFileInfoListener onGetFileInfoListener;

    public GetFileInfoTask(DownloadResponse downloadResponse, DownloadInfo downloadInfo, OnGetFileInfoListener onGetFileInfoListener) {
        this.downloadResponse = downloadResponse;
        this.downloadInfo = downloadInfo;
        this.onGetFileInfoListener = onGetFileInfoListener;
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        try {
            this.executeConnection();
        }
        catch (DownloadException e) {
            this.downloadResponse.handleException(e);
        }
        catch (Exception e) {
            this.downloadResponse.handleException(new DownloadException(9, (Throwable)e));
        }
    }

    private void executeConnection() throws DownloadException {
        block9: {
            HttpURLConnection httpConnection = null;
            try {
                URL url = new URL(this.downloadInfo.getUri());
                httpConnection = (HttpURLConnection)url.openConnection();
                httpConnection.setConnectTimeout(10000);
                httpConnection.setReadTimeout(10000);
                httpConnection.setRequestMethod("GET");
                httpConnection.setRequestProperty("Range", "bytes=0-");
                int responseCode = httpConnection.getResponseCode();
                if (responseCode == 200) {
                    this.parseHttpResponse(httpConnection, false);
                    break block9;
                }
                if (responseCode == 206) {
                    this.parseHttpResponse(httpConnection, true);
                    break block9;
                }
                throw new DownloadException(3, "UnSupported response code:" + responseCode);
            }
            catch (MalformedURLException e) {
                throw new DownloadException(2, "Bad url.", e);
            }
            catch (ProtocolException e) {
                throw new DownloadException(4, "Protocol error", e);
            }
            catch (IOException e) {
                throw new DownloadException(5, "IO error", e);
            }
            catch (Exception e) {
                throw new DownloadException(5, "Unknown error", e);
            }
        }
    }

    private void parseHttpResponse(HttpURLConnection httpConnection, boolean isAcceptRanges) throws DownloadException {
        String contentLength = httpConnection.getHeaderField("Content-Length");
        long length = TextUtils.isEmpty((CharSequence)contentLength) || contentLength.equals("0") || contentLength.equals("-1") ? (long)httpConnection.getContentLength() : Long.parseLong(contentLength);
        if (length <= 0L) {
            throw new DownloadException(6, "length <= 0");
        }
        this.checkIfPause();
        this.onGetFileInfoListener.onSuccess(length, isAcceptRanges);
    }

    private void checkIfPause() {
        if (this.downloadInfo.isPause()) {
            throw new DownloadException(7);
        }
    }

    public static interface OnGetFileInfoListener {
        public void onSuccess(long var1, boolean var3);

        public void onFailed(DownloadException var1);
    }
}

