/*
 * Decompiled with CFR 0.152.
 */
package cn.woblog.android.downloader.core;

import cn.woblog.android.downloader.config.Config;
import cn.woblog.android.downloader.core.DownloadResponse;
import cn.woblog.android.downloader.core.task.DownloadTask;
import cn.woblog.android.downloader.core.task.GetFileInfoTask;
import cn.woblog.android.downloader.core.thread.DownloadThread;
import cn.woblog.android.downloader.domain.DownloadInfo;
import cn.woblog.android.downloader.domain.DownloadThreadInfo;
import cn.woblog.android.downloader.exception.DownloadException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class DownloadTaskImpl
implements DownloadTask,
GetFileInfoTask.OnGetFileInfoListener,
DownloadThread.DownloadProgressListener {
    private final ExecutorService executorService;
    private final DownloadResponse downloadResponse;
    private final DownloadInfo downloadInfo;
    private final Config config;
    private final List<DownloadThread> downloadThreads;
    private final DownloadTaskListener downloadTaskListener;
    private long lastRefreshTime = System.currentTimeMillis();
    private long progress;
    private volatile AtomicBoolean isComputerDownload = new AtomicBoolean(false);

    public DownloadTaskImpl(ExecutorService executorService, DownloadResponse downloadResponse, DownloadInfo downloadInfo, Config config, DownloadTaskListener downloadTaskListener) {
        this.executorService = executorService;
        this.downloadResponse = downloadResponse;
        this.downloadInfo = downloadInfo;
        this.config = config;
        this.downloadTaskListener = downloadTaskListener;
        this.downloadThreads = new ArrayList<DownloadThread>();
    }

    @Override
    public void start() {
        if (this.downloadInfo.getSize() <= 0L) {
            this.getFileInfo();
        } else {
            List<DownloadThreadInfo> downloadThreadInfos = this.downloadInfo.getDownloadThreadInfos();
            for (DownloadThreadInfo downloadThreadInfo : downloadThreadInfos) {
                DownloadThread downloadThread = new DownloadThread(downloadThreadInfo, this.downloadResponse, this.config, this.downloadInfo, this);
                this.executorService.submit(downloadThread);
                this.downloadThreads.add(downloadThread);
            }
            this.downloadInfo.setStatus(2);
            this.downloadResponse.onStatusChanged(this.downloadInfo);
        }
    }

    private void getFileInfo() {
        GetFileInfoTask getFileInfoTask = new GetFileInfoTask(this.downloadResponse, this.downloadInfo, this);
        this.executorService.submit(getFileInfoTask);
    }

    @Override
    public void onSuccess(long size, boolean isSupportRanges) {
        this.downloadInfo.setSupportRanges(isSupportRanges);
        this.downloadInfo.setSize(size);
        ArrayList<DownloadThreadInfo> downloadThreadInfos = new ArrayList<DownloadThreadInfo>();
        if (isSupportRanges) {
            long length = this.downloadInfo.getSize();
            int threads = this.config.getEachDownloadThread();
            long average = length / (long)threads;
            for (int i = 0; i < threads; ++i) {
                long start = average * (long)i;
                long end = i == threads - 1 ? length : start + average - 1L;
                DownloadThreadInfo downloadThreadInfo = new DownloadThreadInfo(i, this.downloadInfo.getId(), this.downloadInfo.getUri(), start, end);
                downloadThreadInfos.add(downloadThreadInfo);
                DownloadThread downloadThread = new DownloadThread(downloadThreadInfo, this.downloadResponse, this.config, this.downloadInfo, this);
                this.executorService.submit(downloadThread);
                this.downloadThreads.add(downloadThread);
            }
        } else {
            DownloadThreadInfo downloadThreadInfo = new DownloadThreadInfo(0, this.downloadInfo.getId(), this.downloadInfo.getUri(), 0L, this.downloadInfo.getSize());
            downloadThreadInfos.add(downloadThreadInfo);
            DownloadThread downloadThread = new DownloadThread(downloadThreadInfo, this.downloadResponse, this.config, this.downloadInfo, this);
            this.executorService.submit(downloadThread);
            this.downloadThreads.add(downloadThread);
        }
        this.downloadInfo.setDownloadThreadInfos(downloadThreadInfos);
        this.downloadInfo.setStatus(2);
        this.downloadResponse.onStatusChanged(this.downloadInfo);
    }

    @Override
    public void onFailed(DownloadException exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onProgress() {
        if (!this.isComputerDownload.get()) {
            DownloadTaskImpl downloadTaskImpl = this;
            synchronized (downloadTaskImpl) {
                if (!this.isComputerDownload.get()) {
                    this.isComputerDownload.set(true);
                    long currentTimeMillis = System.currentTimeMillis();
                    if (currentTimeMillis - this.lastRefreshTime > 1000L) {
                        this.computerDownloadProgress();
                        this.downloadResponse.onStatusChanged(this.downloadInfo);
                        this.lastRefreshTime = currentTimeMillis;
                    }
                    this.isComputerDownload.set(false);
                }
            }
        }
    }

    @Override
    public void onDownloadSuccess() {
        this.computerDownloadProgress();
        if (this.downloadInfo.getProgress() == this.downloadInfo.getSize()) {
            this.downloadInfo.setStatus(5);
            this.downloadResponse.onStatusChanged(this.downloadInfo);
            if (this.downloadTaskListener != null) {
                this.downloadTaskListener.onDownloadSuccess(this.downloadInfo);
            }
        }
    }

    private void computerDownloadProgress() {
        this.progress = 0L;
        List<DownloadThreadInfo> downloadThreadInfos = this.downloadInfo.getDownloadThreadInfos();
        for (DownloadThreadInfo info : downloadThreadInfos) {
            this.progress += info.getProgress();
        }
        this.downloadInfo.setProgress(this.progress);
    }

    public static interface DownloadTaskListener {
        public void onDownloadSuccess(DownloadInfo var1);
    }
}

