/*
 * Decompiled with CFR 0.152.
 */
package cn.woblog.android.downloader.core;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import cn.woblog.android.downloader.core.DownloadResponse;
import cn.woblog.android.downloader.db.DownloadDBController;
import cn.woblog.android.downloader.domain.DownloadInfo;
import cn.woblog.android.downloader.domain.DownloadThreadInfo;
import cn.woblog.android.downloader.exception.DownloadException;

public class DownloadResponseImpl
implements DownloadResponse {
    private static final String TAG = "DownloadResponseImpl";
    private final Handler handler;
    private final DownloadDBController downloadDBController;

    public DownloadResponseImpl(DownloadDBController downloadDBController) {
        this.downloadDBController = downloadDBController;
        this.handler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                DownloadInfo downloadInfo = (DownloadInfo)msg.obj;
                switch (downloadInfo.getStatus()) {
                    case 2: {
                        if (downloadInfo.getDownloadListener() == null) break;
                        downloadInfo.getDownloadListener().onDownloading(downloadInfo.getProgress(), downloadInfo.getSize());
                        break;
                    }
                    case 1: {
                        if (downloadInfo.getDownloadListener() == null) break;
                        downloadInfo.getDownloadListener().onStart();
                        break;
                    }
                    case 3: {
                        if (downloadInfo.getDownloadListener() == null) break;
                        downloadInfo.getDownloadListener().onWaited();
                        break;
                    }
                    case 4: {
                        if (downloadInfo.getDownloadListener() == null) break;
                        downloadInfo.getDownloadListener().onPaused();
                        break;
                    }
                    case 5: {
                        if (downloadInfo.getDownloadListener() == null) break;
                        downloadInfo.getDownloadListener().onDownloadSuccess();
                        break;
                    }
                    case 6: {
                        if (downloadInfo.getDownloadListener() == null) break;
                        downloadInfo.getDownloadListener().onDownloadFailed(downloadInfo.getException());
                        break;
                    }
                    case 7: {
                        if (downloadInfo.getDownloadListener() == null) break;
                        downloadInfo.getDownloadListener().onRemoved();
                    }
                }
            }
        };
    }

    @Override
    public void onStatusChanged(DownloadInfo downloadInfo) {
        if (downloadInfo.getStatus() != 7) {
            this.downloadDBController.createOrUpdate(downloadInfo);
            if (downloadInfo.getDownloadThreadInfos() != null) {
                for (DownloadThreadInfo threadInfo : downloadInfo.getDownloadThreadInfos()) {
                    this.downloadDBController.createOrUpdate(threadInfo);
                }
            }
        }
        Message message = this.handler.obtainMessage(downloadInfo.getId());
        message.obj = downloadInfo;
        message.sendToTarget();
        Log.d((String)TAG, (String)("progress:" + downloadInfo.getProgress() + ",size:" + downloadInfo.getSize()));
    }

    @Override
    public void handleException(DownloadException exception) {
    }
}

