/*
 * Decompiled with CFR 0.152.
 */
package cn.woblog.android.downloader;

import android.app.ActivityManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import cn.woblog.android.downloader.DownloadManagerImpl;
import cn.woblog.android.downloader.callback.DownloadManager;
import cn.woblog.android.downloader.config.Config;
import java.util.List;

public class DownloadService
extends Service {
    private static final String TAG = "DownloadService";
    public static DownloadManager downloadManager;

    public static DownloadManager getDownloadManager(Context context) {
        return DownloadService.getDownloadManager(context, null);
    }

    public static DownloadManager getDownloadManager(Context context, Config config) {
        if (!DownloadService.isServiceRunning(context)) {
            Intent downloadSvr = new Intent(context, DownloadService.class);
            context.startService(downloadSvr);
        }
        if (downloadManager == null) {
            downloadManager = DownloadManagerImpl.getInstance(context, config);
        }
        return downloadManager;
    }

    private static boolean isServiceRunning(Context context) {
        boolean isRunning = false;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List serviceList = activityManager.getRunningServices(Integer.MAX_VALUE);
        if (serviceList == null || serviceList.size() == 0) {
            return false;
        }
        for (int i = 0; i < serviceList.size(); ++i) {
            if (!((ActivityManager.RunningServiceInfo)serviceList.get((int)i)).service.getClassName().equals(DownloadService.class.getName())) continue;
            isRunning = true;
            break;
        }
        return isRunning;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onDestroy() {
        if (downloadManager != null) {
            downloadManager.onDestroy();
            downloadManager = null;
        }
        super.onDestroy();
    }
}

