/*
 * Decompiled with CFR 0.152.
 */
package cn.woblog.android.downloader;

import android.content.Context;
import cn.woblog.android.downloader.callback.DownloadManager;
import cn.woblog.android.downloader.config.Config;
import cn.woblog.android.downloader.core.DownloadResponse;
import cn.woblog.android.downloader.core.DownloadResponseImpl;
import cn.woblog.android.downloader.core.DownloadTaskImpl;
import cn.woblog.android.downloader.core.task.DownloadTask;
import cn.woblog.android.downloader.db.DefaultDownloadDBController;
import cn.woblog.android.downloader.db.DownloadDBController;
import cn.woblog.android.downloader.domain.DownloadInfo;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class DownloadManagerImpl
implements DownloadManager,
DownloadTaskImpl.DownloadTaskListener {
    private static final int MIN_EXECUTE_INTERVAL = 500;
    private static DownloadManagerImpl instance;
    private final ExecutorService executorService;
    private final ConcurrentHashMap<Integer, DownloadTask> cacheDownloadTask;
    private final List<DownloadInfo> downloadingCaches;
    private final Context context;
    private final DownloadResponse downloadResponse;
    private final DownloadDBController downloadDBController;
    private final Config config;
    private long lastExecuteTime;

    private DownloadManagerImpl(Context context, Config config) {
        this.context = context;
        this.config = config == null ? new Config() : config;
        this.downloadDBController = new DefaultDownloadDBController(context, this.config);
        this.cacheDownloadTask = new ConcurrentHashMap();
        this.downloadDBController.pauseAllDownloading();
        this.downloadingCaches = this.downloadDBController.findAllDownloading();
        this.executorService = Executors.newFixedThreadPool(this.config.getDownloadThread());
        this.downloadResponse = new DownloadResponseImpl(this.downloadDBController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadManager getInstance(Context context, Config config) {
        Class<DownloadManagerImpl> clazz = DownloadManagerImpl.class;
        synchronized (DownloadManagerImpl.class) {
            if (instance == null) {
                instance = new DownloadManagerImpl(context, config);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void download(DownloadInfo downloadInfo) {
        this.downloadingCaches.add(downloadInfo);
        this.prepareDownload(downloadInfo);
    }

    private void prepareDownload(DownloadInfo downloadInfo) {
        if (this.cacheDownloadTask.size() >= this.config.getDownloadThread()) {
            downloadInfo.setStatus(3);
            this.downloadResponse.onStatusChanged(downloadInfo);
        } else {
            DownloadTaskImpl downloadTask = new DownloadTaskImpl(this.executorService, this.downloadResponse, downloadInfo, this.config, this);
            this.cacheDownloadTask.put(downloadInfo.getId(), downloadTask);
            downloadInfo.setStatus(1);
            this.downloadResponse.onStatusChanged(downloadInfo);
            downloadTask.start();
        }
    }

    @Override
    public void pause(DownloadInfo downloadInfo) {
        if (this.isExecute()) {
            downloadInfo.setStatus(4);
            this.cacheDownloadTask.remove(downloadInfo.getId());
            this.downloadResponse.onStatusChanged(downloadInfo);
            this.prepareDownloadNextTask();
        }
    }

    private void prepareDownloadNextTask() {
        for (DownloadInfo downloadInfo : this.downloadingCaches) {
            if (downloadInfo.getStatus() != 3) continue;
            this.prepareDownload(downloadInfo);
            break;
        }
    }

    @Override
    public void resume(DownloadInfo downloadInfo) {
        if (this.isExecute()) {
            this.cacheDownloadTask.remove(downloadInfo.getId());
            this.prepareDownload(downloadInfo);
        }
    }

    @Override
    public void remove(DownloadInfo downloadInfo) {
        downloadInfo.setStatus(7);
        this.cacheDownloadTask.remove(downloadInfo.getId());
        this.downloadingCaches.remove(downloadInfo);
        this.downloadDBController.delete(downloadInfo);
        this.downloadResponse.onStatusChanged(downloadInfo);
    }

    @Override
    public void onDestroy() {
    }

    @Override
    public DownloadInfo getDownloadById(int id) {
        DownloadInfo downloadInfo = null;
        for (DownloadInfo d : this.downloadingCaches) {
            if (d.getId() != id) continue;
            downloadInfo = d;
            break;
        }
        if (downloadInfo == null) {
            downloadInfo = this.downloadDBController.findDownloadedInfoById(id);
        }
        return downloadInfo;
    }

    @Override
    public List<DownloadInfo> findAllDownloading() {
        return this.downloadingCaches;
    }

    @Override
    public List<DownloadInfo> findAllDownloaded() {
        return this.downloadDBController.findAllDownloaded();
    }

    @Override
    public DownloadDBController getDownloadDBController() {
        return this.downloadDBController;
    }

    @Override
    public void onDownloadSuccess(DownloadInfo downloadInfo) {
        this.cacheDownloadTask.remove(downloadInfo.getId());
        this.downloadingCaches.remove(downloadInfo);
        this.prepareDownloadNextTask();
    }

    public boolean isExecute() {
        if (System.currentTimeMillis() - this.lastExecuteTime > 500L) {
            this.lastExecuteTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }
}

