/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dson.pb;

import cn.wjybxx.dson.io.BinaryUtils;
import cn.wjybxx.dson.io.DsonIOException;
import cn.wjybxx.dson.pb.DsonProtobufOutput;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public class DsonProtobufOutputs {
    public static DsonProtobufOutput newInstance(byte[] buffer) {
        return new ArrayOutput(buffer);
    }

    public static DsonProtobufOutput newInstance(byte[] buffer, int offset, int length) {
        return new ArrayOutput(buffer, offset, length);
    }

    public static DsonProtobufOutput newInstance(ByteBuffer byteBuffer) {
        return new ByteBufferOutput(byteBuffer);
    }

    static class ArrayOutput
    extends CodedOutput {
        private final byte[] buffer;
        private final int offset;
        private final int limit;

        ArrayOutput(byte[] buffer) {
            this(buffer, 0, buffer.length);
        }

        ArrayOutput(byte[] buffer, int offset, int length) {
            if (offset >= buffer.length) {
                throw new IllegalArgumentException();
            }
            this.buffer = buffer;
            this.offset = offset;
            this.limit = offset + length;
            this.codedOutputStream = CodedOutputStream.newInstance((byte[])buffer, (int)offset, (int)length);
            this.codedOutputStreamOffset = offset;
        }

        public int getPosition() {
            return this.codedOutputStreamOffset - this.offset + this.codedOutputStream.getTotalBytesWritten();
        }

        public void setPosition(int writerIndex) {
            Objects.checkIndex(writerIndex, this.limit - this.offset);
            if (this.getPosition() == writerIndex) {
                return;
            }
            try {
                this.codedOutputStream.flush();
                int newOffset = this.offset + writerIndex;
                this.codedOutputStream = CodedOutputStream.newInstance((byte[])this.buffer, (int)newOffset, (int)(this.limit - newOffset));
                this.codedOutputStreamOffset = newOffset;
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void setByte(int writerIndex, byte value) {
            Objects.checkIndex(writerIndex, this.limit - this.offset);
            int newOffset = this.offset + writerIndex;
            BinaryUtils.checkBuffer((byte[])this.buffer, (int)newOffset, (int)1);
            this.buffer[newOffset] = value;
        }

        public void setFixedInt32(int writerIndex, int value) {
            Objects.checkIndex(writerIndex, this.limit - this.offset);
            int newOffset = this.offset + writerIndex;
            BinaryUtils.checkBuffer((byte[])this.buffer, (int)newOffset, (int)4);
            BinaryUtils.setIntLE((byte[])this.buffer, (int)newOffset, (int)value);
        }

        public String toString() {
            return "ArrayOutput{arrayLength=" + this.buffer.length + ", offset=" + this.offset + ", limit=" + this.limit + ", codedOutputStreamOffset=" + this.codedOutputStreamOffset + ", codedOutputStreamTotalBytesWritten=" + this.codedOutputStream.getTotalBytesWritten() + ", totalBytesWritten=" + this.getPosition() + "}";
        }
    }

    static class ByteBufferOutput
    extends CodedOutput {
        private final ByteBuffer byteBuffer;
        private final int offset;

        ByteBufferOutput(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.offset = byteBuffer.position();
            this.codedOutputStream = CodedOutputStream.newInstance((ByteBuffer)byteBuffer);
            this.codedOutputStreamOffset = this.offset;
        }

        public int getPosition() {
            return this.codedOutputStreamOffset - this.offset + this.codedOutputStream.getTotalBytesWritten();
        }

        public void setPosition(int writerIndex) {
            Objects.checkIndex(writerIndex, this.byteBuffer.limit() - this.offset);
            if (this.getPosition() == writerIndex) {
                return;
            }
            try {
                this.codedOutputStream.flush();
                int newOffset = this.offset + writerIndex;
                BinaryUtils.position((Buffer)this.byteBuffer, (int)newOffset);
                this.codedOutputStream = CodedOutputStream.newInstance((ByteBuffer)this.byteBuffer);
                this.codedOutputStreamOffset = newOffset;
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void setByte(int writerIndex, byte value) {
            int newOffset = this.offset + writerIndex;
            this.byteBuffer.put(newOffset, value);
        }

        public void setFixedInt32(int writerIndex, int value) {
            int newOffset = this.offset + writerIndex;
            this.byteBuffer.putInt(newOffset, value);
        }
    }

    static abstract class CodedOutput
    implements DsonProtobufOutput {
        CodedOutputStream codedOutputStream;
        int codedOutputStreamOffset;

        CodedOutput() {
        }

        public void writeRawByte(byte value) {
            try {
                this.codedOutputStream.writeRawByte(value);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeRawByte(int value) {
            try {
                this.codedOutputStream.writeRawByte((byte)value);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeInt32(int value) {
            try {
                this.codedOutputStream.writeInt32NoTag(value);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeUint32(int value) {
            try {
                this.codedOutputStream.writeUInt32NoTag(value);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeSint32(int value) {
            try {
                this.codedOutputStream.writeSInt32NoTag(value);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeFixed32(int value) {
            try {
                this.codedOutputStream.writeFixed32NoTag(value);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeInt64(long value) {
            try {
                this.codedOutputStream.writeInt64NoTag(value);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeUint64(long value) {
            try {
                this.codedOutputStream.writeUInt64NoTag(value);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeSint64(long value) {
            try {
                this.codedOutputStream.writeSInt64NoTag(value);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeFixed64(long value) {
            try {
                this.codedOutputStream.writeFixed64NoTag(value);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeFloat(float value) {
            try {
                this.codedOutputStream.writeFloatNoTag(value);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeDouble(double value) {
            try {
                this.codedOutputStream.writeDoubleNoTag(value);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeBool(boolean value) {
            try {
                this.codedOutputStream.writeBoolNoTag(value);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeString(String value) {
            try {
                this.codedOutputStream.writeStringNoTag(value);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeRawBytes(byte[] data) {
            try {
                this.codedOutputStream.writeRawBytes(data, 0, data.length);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void writeRawBytes(byte[] data, int offset, int length) {
            try {
                this.codedOutputStream.writeRawBytes(data, offset, length);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        @Override
        public void writeMessage(MessageLite message) {
            try {
                message.writeTo(this.codedOutputStream);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public int spaceLeft() {
            return this.codedOutputStream.spaceLeft();
        }

        public void flush() {
            try {
                this.codedOutputStream.flush();
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void close() {
        }
    }
}

