/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dson.pb;

import cn.wjybxx.dson.io.BinaryUtils;
import cn.wjybxx.dson.io.DsonIOException;
import cn.wjybxx.dson.pb.DsonProtobufInput;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;

public class DsonProtobufInputs {
    private static final ExtensionRegistryLite EMPTY_REGISTRY = ExtensionRegistryLite.getEmptyRegistry();

    public static DsonProtobufInput newInstance(byte[] buffer) {
        return new ArrayInput(buffer);
    }

    public static DsonProtobufInput newInstance(byte[] buffer, int offset, int length) {
        return new ArrayInput(buffer, offset, length);
    }

    public static DsonProtobufInput newInstance(ByteBuffer byteBuffer) {
        return new ByteBufferInput(byteBuffer);
    }

    static class ArrayInput
    extends CodedInput {
        final byte[] buffer;
        final int rawOffset;
        final int rawLimit;

        ArrayInput(byte[] buffer) {
            this(buffer, 0, buffer.length);
        }

        ArrayInput(byte[] buffer, int offset, int length) {
            this.buffer = buffer;
            this.rawOffset = offset;
            this.rawLimit = offset + length;
            this.codedInputStream = CodedInputStream.newInstance((byte[])buffer, (int)offset, (int)length);
            this.codedInputStreamOffset = offset;
        }

        public int getPosition() {
            return this.codedInputStreamOffset - this.rawOffset + this.codedInputStream.getTotalBytesRead();
        }

        public void setPosition(int readerIndex) {
            Objects.checkIndex(readerIndex, this.rawLimit - this.rawOffset);
            int seek = readerIndex - this.getPosition();
            if (seek == 0) {
                return;
            }
            if (seek > 0) {
                this.skipRawBytes(seek);
                return;
            }
            int bufferPos = this.rawOffset + readerIndex;
            this.codedInputStream = CodedInputStream.newInstance((byte[])this.buffer, (int)bufferPos, (int)(this.rawLimit - readerIndex));
            this.codedInputStreamOffset = bufferPos;
        }

        public byte getByte(int readerIndex) {
            int bufferPos = this.rawOffset + readerIndex;
            BinaryUtils.checkBuffer((byte[])this.buffer, (int)bufferPos, (int)1);
            return this.buffer[bufferPos];
        }

        public int getFixed32(int readerIndex) {
            int bufferPos = this.rawOffset + readerIndex;
            BinaryUtils.checkBuffer((byte[])this.buffer, (int)bufferPos, (int)4);
            return BinaryUtils.getIntLE((byte[])this.buffer, (int)bufferPos);
        }
    }

    static class ByteBufferInput
    extends CodedInput {
        private final ByteBuffer byteBuffer;
        private final int offset;

        public ByteBufferInput(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
            this.offset = byteBuffer.position();
            this.codedInputStream = CodedInputStream.newInstance((ByteBuffer)byteBuffer);
            this.codedInputStreamOffset = this.offset;
        }

        public int getPosition() {
            return this.codedInputStreamOffset - this.offset + this.codedInputStream.getTotalBytesRead();
        }

        public void setPosition(int readerIndex) {
            Objects.checkIndex(readerIndex, this.byteBuffer.limit() - this.offset);
            int seek = readerIndex - this.getPosition();
            if (seek == 0) {
                return;
            }
            if (seek > 0) {
                this.skipRawBytes(seek);
                return;
            }
            int bufferPos = this.offset + readerIndex;
            BinaryUtils.position((Buffer)this.byteBuffer, (int)bufferPos);
            this.codedInputStream = CodedInputStream.newInstance((ByteBuffer)this.byteBuffer);
            this.codedInputStreamOffset = bufferPos;
        }

        public byte getByte(int readerIndex) {
            int bufferPos = this.offset + readerIndex;
            return this.byteBuffer.get(bufferPos);
        }

        public int getFixed32(int readerIndex) {
            int bufferPos = this.offset + readerIndex;
            return this.byteBuffer.getInt(bufferPos);
        }
    }

    static abstract class CodedInput
    implements DsonProtobufInput {
        CodedInputStream codedInputStream;
        int codedInputStreamOffset;

        CodedInput() {
        }

        public byte readRawByte() {
            try {
                return this.codedInputStream.readRawByte();
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public int readInt32() {
            try {
                return this.codedInputStream.readInt32();
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public int readUint32() {
            try {
                return this.codedInputStream.readUInt32();
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public int readSint32() {
            try {
                return this.codedInputStream.readSInt32();
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public int readFixed32() {
            try {
                return this.codedInputStream.readFixed32();
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public long readInt64() {
            try {
                return this.codedInputStream.readInt64();
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public long readUint64() {
            try {
                return this.codedInputStream.readUInt64();
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public long readSint64() {
            try {
                return this.codedInputStream.readSInt64();
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public long readFixed64() {
            try {
                return this.codedInputStream.readFixed64();
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public float readFloat() {
            try {
                return this.codedInputStream.readFloat();
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public double readDouble() {
            try {
                return this.codedInputStream.readDouble();
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public boolean readBool() {
            try {
                return this.codedInputStream.readRawByte() > 0;
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public String readString() {
            try {
                return this.codedInputStream.readString();
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public byte[] readRawBytes(int size) {
            try {
                return this.codedInputStream.readRawBytes(size);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void skipRawBytes(int n) {
            try {
                this.codedInputStream.skipRawBytes(n);
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        @Override
        public <T> T readMessage(Parser<T> parser) {
            try {
                return (T)parser.parseFrom(this.codedInputStream, EMPTY_REGISTRY);
            }
            catch (InvalidProtocolBufferException e) {
                throw DsonIOException.wrap((Exception)((Object)e));
            }
        }

        public int pushLimit(int byteLimit) {
            try {
                return this.codedInputStream.pushLimit(byteLimit);
            }
            catch (InvalidProtocolBufferException e) {
                throw DsonIOException.wrap((Exception)((Object)e));
            }
        }

        public void popLimit(int oldLimit) {
            this.codedInputStream.popLimit(oldLimit);
        }

        public int getBytesUntilLimit() {
            return this.codedInputStream.getBytesUntilLimit();
        }

        public boolean isAtEnd() {
            try {
                return this.codedInputStream.isAtEnd();
            }
            catch (IOException e) {
                throw DsonIOException.wrap((Exception)e);
            }
        }

        public void close() {
        }
    }
}

