/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.CollectionUtils;
import cn.wjybxx.base.Constant;
import cn.wjybxx.base.ConstantPool;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ConstantMap<T extends Constant<T>> {
    private final List<T> immutableValues;
    private final List<String> immutableNames;
    private final Map<String, T> constants;

    ConstantMap(ConstantPool<T> pool) {
        List<T> immutableValues = CollectionUtils.toImmutableList(pool.values());
        this.immutableValues = immutableValues;
        this.immutableNames = immutableValues.stream().map(Constant::name).toList();
        this.constants = immutableValues.stream().collect(Collectors.toUnmodifiableMap(Constant::name, e -> e));
    }

    public final boolean exists(String name) {
        return this.constants.containsKey(name);
    }

    @Nullable
    public final T get(String name) {
        return (T)((Constant)this.constants.get(name));
    }

    public final T getOrThrow(String name) {
        Constant constant = (Constant)this.constants.get(name);
        if (null == constant) {
            throw new IllegalArgumentException(name + " does not exist");
        }
        return (T)constant;
    }

    public final List<String> names() {
        return this.immutableNames;
    }

    public final List<T> values() {
        return this.immutableValues;
    }
}

