/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.collection;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface DelayedCompressList<E> {
    public static final int INDEX_NOT_FOUND = -1;

    public void beginItr();

    public void endItr();

    public boolean isIterating();

    public boolean isDelayed();

    public boolean add(E var1);

    @Nullable
    public E get(int var1);

    public E set(int var1, E var2);

    default public boolean remove(Object e) {
        if (e == null) {
            return false;
        }
        int i = this.index(e);
        if (i >= 0) {
            this.removeAt(i);
            return true;
        }
        return false;
    }

    default public boolean removeRef(Object e) {
        if (e == null) {
            return false;
        }
        int i = this.indexOfRef(e);
        if (i >= 0) {
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public E removeAt(int var1);

    public void clear();

    public int index(@Nullable Object var1);

    public int lastIndex(@Nullable Object var1);

    public int indexOfRef(@Nullable Object var1);

    public int lastIndexOfRef(@Nullable Object var1);

    default public boolean contains(Object e) {
        return this.index(e) >= 0;
    }

    default public boolean containsRef(Object e) {
        return this.indexOfRef(e) >= 0;
    }

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public int realSize();

    public boolean isRealEmpty();

    public void sort(@Nonnull Comparator<? super E> var1);

    default public boolean addAll(@Nonnull Collection<? extends E> c) {
        boolean r = false;
        for (E e : c) {
            r |= this.add(e);
        }
        return r;
    }

    default public int indexCustom(Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        int size = this.size();
        if (size == 0) {
            return -1;
        }
        for (int index = 0; index < size; ++index) {
            E e = this.get(index);
            if (e == null || !predicate.test(e)) continue;
            return index;
        }
        return -1;
    }

    default public int lastIndexCustom(Predicate<? super E> predicate) {
        Objects.requireNonNull(predicate);
        int size = this.size();
        if (size == 0) {
            return -1;
        }
        for (int index = size - 1; index >= 0; --index) {
            E e = this.get(index);
            if (e == null || !predicate.test(e)) continue;
            return index;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int size = this.size();
        if (size == 0) {
            return;
        }
        this.beginItr();
        try {
            for (int index = 0; index < size; ++index) {
                E e = this.get(index);
                if (e == null) continue;
                action.accept(e);
            }
        }
        finally {
            this.endItr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void forEach(ObjIntConsumer<? super E> action) {
        Objects.requireNonNull(action);
        int size = this.size();
        if (size == 0) {
            return;
        }
        this.beginItr();
        try {
            for (int index = 0; index < size; ++index) {
                E e = this.get(index);
                if (e == null) continue;
                action.accept(e, index);
            }
        }
        finally {
            this.endItr();
        }
    }

    default public int collectTo(Collection<? super E> out) {
        Objects.requireNonNull(out);
        int size = this.size();
        if (size == 0) {
            return 0;
        }
        int count = 0;
        for (int index = 0; index < size; ++index) {
            E e = this.get(index);
            if (e == null) continue;
            out.add(e);
            ++count;
        }
        return count;
    }
}

