/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.collection;

import cn.wjybxx.base.collection.DequeOverflowBehavior;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class BoundedArrayDeque<E>
implements Deque<E> {
    private int capacity;
    private final DequeOverflowBehavior overflowBehavior;
    private final ArrayDeque<E> arrayDeque;

    public BoundedArrayDeque(int capacity, DequeOverflowBehavior overflowBehavior) {
        if (capacity < 0) {
            throw new IllegalArgumentException("maxSize: " + capacity);
        }
        this.capacity = capacity;
        this.overflowBehavior = overflowBehavior;
        this.arrayDeque = capacity <= 10 ? new ArrayDeque(capacity) : new ArrayDeque();
    }

    public void setCapacity(int capacity, DequeOverflowBehavior overflowBehavior) {
        if (capacity < 0) {
            throw new IllegalArgumentException("maxSize: " + capacity);
        }
        if (this.capacity == capacity) {
            return;
        }
        if (capacity == 0) {
            if (this.arrayDeque.size() > 0 && overflowBehavior != DequeOverflowBehavior.DISCARD_HEAD && overflowBehavior != DequeOverflowBehavior.DISCARD_TAIL) {
                throw new IllegalStateException("queue is full");
            }
            this.arrayDeque.clear();
        } else if (capacity < this.arrayDeque.size()) {
            if (overflowBehavior == DequeOverflowBehavior.DISCARD_HEAD) {
                while (this.arrayDeque.size() > capacity) {
                    this.arrayDeque.pollFirst();
                }
            } else if (overflowBehavior == DequeOverflowBehavior.DISCARD_TAIL) {
                while (this.arrayDeque.size() > capacity) {
                    this.arrayDeque.pollLast();
                }
            } else {
                throw new IllegalStateException("queue is full");
            }
        }
        this.capacity = capacity;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        return this.arrayDeque.remove();
    }

    @Override
    public E poll() {
        return this.arrayDeque.poll();
    }

    @Override
    public E element() {
        return this.arrayDeque.element();
    }

    @Override
    public E peek() {
        return this.arrayDeque.peek();
    }

    @Override
    public boolean add(E e) {
        if (this.capacity == 0) {
            return false;
        }
        this.addLast(e);
        return true;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends E> c) {
        if (this.capacity == 0 || c.isEmpty()) {
            return false;
        }
        for (E e : c) {
            this.addLast(e);
        }
        return true;
    }

    @Override
    public void addFirst(E e) {
        if (!this.offerFirst(e)) {
            throw new IllegalStateException("Queue is full");
        }
    }

    @Override
    public void addLast(E e) {
        if (!this.offerLast(e)) {
            throw new IllegalStateException("Queue is full");
        }
    }

    @Override
    public boolean offerFirst(E e) {
        Objects.requireNonNull(e);
        if (this.arrayDeque.size() == this.capacity) {
            if (!this.overflowBehavior.allowDiscardTail()) {
                return false;
            }
            this.arrayDeque.pollLast();
        }
        this.arrayDeque.offerFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        Objects.requireNonNull(e);
        if (this.arrayDeque.size() == this.capacity) {
            if (!this.overflowBehavior.allowDiscardHead()) {
                return false;
            }
            this.arrayDeque.pollFirst();
        }
        this.arrayDeque.offerLast(e);
        return true;
    }

    @Override
    public E getFirst() {
        return this.arrayDeque.getFirst();
    }

    @Override
    public E peekFirst() {
        return this.arrayDeque.peekFirst();
    }

    @Override
    public E removeFirst() {
        return this.arrayDeque.removeFirst();
    }

    @Override
    public E pollFirst() {
        return this.arrayDeque.pollFirst();
    }

    @Override
    public E getLast() {
        return this.arrayDeque.getLast();
    }

    @Override
    public E peekLast() {
        return this.arrayDeque.peekLast();
    }

    @Override
    public E removeLast() {
        return this.arrayDeque.removeLast();
    }

    @Override
    public E pollLast() {
        return this.arrayDeque.pollLast();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.arrayDeque.pop();
    }

    @Override
    public int size() {
        return this.arrayDeque.size();
    }

    @Override
    public boolean isEmpty() {
        return this.arrayDeque.isEmpty();
    }

    @Override
    public void clear() {
        this.arrayDeque.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.arrayDeque.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.arrayDeque.remove(o);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.arrayDeque.removeFirstOccurrence(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.arrayDeque.removeLastOccurrence(o);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.arrayDeque.removeIf(filter);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return this.arrayDeque.containsAll(c);
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        return this.arrayDeque.removeAll(c);
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.arrayDeque.retainAll(c);
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return this.arrayDeque.iterator();
    }

    @Override
    @Nonnull
    public Iterator<E> descendingIterator() {
        return this.arrayDeque.descendingIterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.arrayDeque.spliterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.arrayDeque.forEach(action);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.arrayDeque.toArray();
    }

    @Override
    @Nonnull
    public <T> T[] toArray(T[] a) {
        return this.arrayDeque.toArray(a);
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.arrayDeque.toArray(generator);
    }

    @Override
    public Stream<E> stream() {
        return this.arrayDeque.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.arrayDeque.parallelStream();
    }
}

