/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.time;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class StopWatch {
    private final String name;
    private State state = State.UNSTARTED;
    private long startTimeNanos;
    private long elapsedNanos;
    private long stepElapsedNanos;
    private final List<Item> itemList = new ArrayList<Item>();

    public StopWatch(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    public static StopWatch create(String name) {
        return new StopWatch(name);
    }

    public static StopWatch createStarted(String name) {
        StopWatch sw = new StopWatch(name);
        sw.start();
        return sw;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStarted() {
        return this.state == State.RUNNING || this.state == State.SUSPENDED;
    }

    public boolean isRunning() {
        return this.state == State.RUNNING;
    }

    public boolean isSuspended() {
        return this.state == State.SUSPENDED;
    }

    public boolean isStopped() {
        return this.state == State.STOPPED;
    }

    public void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("Stopwatch is running. ");
        }
        this.state = State.RUNNING;
        this.startTimeNanos = System.nanoTime();
        this.stepElapsedNanos = 0L;
        this.elapsedNanos = 0L;
        this.itemList.clear();
    }

    public void logStep(String stepName) {
        Objects.requireNonNull(stepName, "stepName");
        if (this.state != State.RUNNING) {
            throw new IllegalStateException("Stopwatch is not running. ");
        }
        long delta = System.nanoTime() - this.startTimeNanos;
        this.startTimeNanos += delta;
        this.elapsedNanos += delta;
        this.stepElapsedNanos += delta;
        this.itemList.add(new Item(stepName, this.stepElapsedNanos));
        this.stepElapsedNanos = 0L;
    }

    public void suspend() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Stopwatch must be started to suspend. ");
        }
        if (this.state == State.RUNNING) {
            long delta = System.nanoTime() - this.startTimeNanos;
            this.state = State.SUSPENDED;
            this.elapsedNanos += delta;
            this.stepElapsedNanos += delta;
        }
    }

    public void resume() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Stopwatch must be started to resume. ");
        }
        if (this.state == State.SUSPENDED) {
            this.state = State.RUNNING;
            this.startTimeNanos = System.nanoTime();
        }
    }

    public void stop() {
        this.stop(null);
    }

    public void stop(String stepName) {
        if (!this.isStarted()) {
            return;
        }
        if (this.state == State.RUNNING) {
            long delta = System.nanoTime() - this.startTimeNanos;
            this.elapsedNanos += delta;
            this.stepElapsedNanos += delta;
            if (stepName != null) {
                this.itemList.add(new Item(stepName, this.stepElapsedNanos));
                this.stepElapsedNanos = 0L;
            }
        }
        this.state = State.STOPPED;
    }

    public void reset() {
        if (this.state == State.UNSTARTED) {
            return;
        }
        this.state = State.UNSTARTED;
        this.startTimeNanos = 0L;
        this.stepElapsedNanos = 0L;
        this.elapsedNanos = 0L;
        this.itemList.clear();
    }

    public void restart() {
        this.reset();
        this.start();
    }

    public Duration elapsed() {
        return Duration.ofNanos(this.elapsedNanos());
    }

    public long elapsed(TimeUnit desiredUnit) {
        return desiredUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    public Duration stepElapsed() {
        return Duration.ofNanos(this.stepElapsedNanos());
    }

    public long stepElapsed(TimeUnit desiredUnit) {
        return desiredUnit.convert(this.stepElapsedNanos(), TimeUnit.NANOSECONDS);
    }

    public List<Map.Entry<String, Duration>> listStepElapsed() {
        ArrayList<Map.Entry<String, Duration>> result = new ArrayList<Map.Entry<String, Duration>>(this.itemList.size());
        for (Item item : this.itemList) {
            result.add(Map.entry(item.stepName, Duration.ofNanos(item.elapsedNanos)));
        }
        return result;
    }

    private long elapsedNanos() {
        if (this.state == State.RUNNING) {
            return this.elapsedNanos + (System.nanoTime() - this.startTimeNanos);
        }
        return this.elapsedNanos;
    }

    private long stepElapsedNanos() {
        if (this.state == State.RUNNING) {
            return this.stepElapsedNanos + (System.nanoTime() - this.startTimeNanos);
        }
        return this.stepElapsedNanos;
    }

    public String getSortedLog() {
        if (!this.itemList.isEmpty()) {
            ArrayList<Item> copiedItems = new ArrayList<Item>(this.itemList);
            copiedItems.sort(null);
            return this.toString(copiedItems);
        }
        return this.toString(this.itemList);
    }

    public String getLog() {
        return this.toString(this.itemList);
    }

    public String toString() {
        return this.toString(this.itemList);
    }

    private String toString(List<Item> itemList) {
        StringBuilder sb = new StringBuilder(32);
        sb.append("StopWatch[").append(this.name).append('=').append(this.elapsedNanos() / 1000000L).append("ms]");
        sb.append('[');
        for (int i = 0; i < itemList.size(); ++i) {
            Item item = itemList.get(i);
            if (i > 0) {
                sb.append(',');
            }
            sb.append(item.stepName).append('=').append(item.elapsedNanos / 1000000L).append("ms");
        }
        sb.append(']');
        return sb.toString();
    }

    private static enum State {
        UNSTARTED,
        RUNNING,
        SUSPENDED,
        STOPPED;

    }

    private static class Item
    implements Comparable<Item> {
        final String stepName;
        final long elapsedNanos;

        Item(String stepName, long elapsedNanos) {
            this.stepName = stepName;
            this.elapsedNanos = elapsedNanos;
        }

        @Override
        public int compareTo(Item that) {
            int timeCompareResult = Long.compare(this.elapsedNanos, that.elapsedNanos);
            if (timeCompareResult != 0) {
                return -1 * timeCompareResult;
            }
            return this.stepName.compareTo(that.stepName);
        }
    }
}

