/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import java.util.Arrays;
import java.util.Objects;

public class ObjectUtils {
    public static <V> V nullToDef(V obj, V def) {
        return obj == null ? def : obj;
    }

    public static int hashCode(Object first) {
        return Objects.hashCode(first);
    }

    public static int hashCode(Object first, Object second) {
        int result = Objects.hashCode(first);
        result = 31 * result + Objects.hashCode(second);
        return result;
    }

    public static int hashCode(Object first, Object second, Object third) {
        int result = Objects.hashCode(first);
        result = 31 * result + Objects.hashCode(second);
        result = 31 * result + Objects.hashCode(third);
        return result;
    }

    public static int hashCode(Object ... args) {
        return Arrays.hashCode(args);
    }

    public static String toString(Object object, String nullDef) {
        return object == null ? nullDef : object.toString();
    }

    public static String toStringIfNotNull(Object object) {
        return object == null ? null : object.toString();
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.isEmpty();
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = ObjectUtils.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static <T extends CharSequence> T emptyToDef(T str, T def) {
        return ObjectUtils.isEmpty(str) ? def : str;
    }

    public static <T extends CharSequence> T blankToDef(T str, T def) {
        return ObjectUtils.isBlank(str) ? def : str;
    }

    public static String emptyToDef(String str, String def) {
        return ObjectUtils.isEmpty(str) ? def : str;
    }

    public static String blankToDef(String str, String def) {
        return ObjectUtils.isBlank(str) ? def : str;
    }

    public static char lastChar(CharSequence value) {
        return value.charAt(value.length() - 1);
    }

    public static String firstCharToUpperCase(String str) {
        int length = ObjectUtils.length(str);
        if (length == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            StringBuilder sb = new StringBuilder(str);
            sb.setCharAt(0, Character.toUpperCase(firstChar));
            return sb.toString();
        }
        return str;
    }

    public static String firstCharToLowerCase(String str) {
        int length = ObjectUtils.length(str);
        if (length == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            StringBuilder sb = new StringBuilder(str);
            sb.setCharAt(0, Character.toLowerCase(firstChar));
            return sb.toString();
        }
        return str;
    }

    public static boolean containsWhitespace(CharSequence cs) {
        int strLen = ObjectUtils.length(cs);
        if (strLen == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(cs.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

