/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.pool;

import cn.wjybxx.base.MathCommon;
import cn.wjybxx.base.pool.ObjectPool;
import cn.wjybxx.base.pool.ResetPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class DefaultObjectPool<T>
implements ObjectPool<T> {
    private static final int DEFAULT_POOL_SIZE = 1024;
    private final Supplier<? extends T> factory;
    private final ResetPolicy<? super T> resetPolicy;
    private final int poolSize;
    private final ArrayList<T> freeObjects;

    public DefaultObjectPool(Supplier<? extends T> factory, ResetPolicy<? super T> resetPolicy) {
        this(factory, resetPolicy, 1024);
    }

    public DefaultObjectPool(Supplier<? extends T> factory, ResetPolicy<? super T> resetPolicy, int poolSize) {
        if (poolSize < 0) {
            throw new IllegalArgumentException("poolSize: " + poolSize);
        }
        this.factory = Objects.requireNonNull(factory, "factory");
        this.resetPolicy = Objects.requireNonNull(resetPolicy, "resetPolicy");
        this.poolSize = poolSize;
        this.freeObjects = new ArrayList(MathCommon.clamp(poolSize, 0, 10));
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    @Override
    public T get() {
        return this.acquire();
    }

    @Override
    public T acquire() {
        int size = this.freeObjects.size();
        if (size > 0) {
            return this.freeObjects.remove(size - 1);
        }
        return this.factory.get();
    }

    @Override
    public void release(T object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        this.resetPolicy.reset(object);
        if (this.freeObjects.size() < this.poolSize) {
            this.freeObjects.add(object);
        }
    }

    @Override
    public void releaseAll(Collection<? extends T> objects) {
        if (objects == null) {
            throw new IllegalArgumentException("objects cannot be null.");
        }
        ArrayList<T> freeObjects = this.freeObjects;
        int poolSize = this.poolSize;
        ResetPolicy<Object> resetPolicy = this.resetPolicy;
        if (objects instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)objects;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object obj = arrayList.get(i);
                if (null == obj) continue;
                resetPolicy.reset(obj);
                if (freeObjects.size() >= poolSize) continue;
                freeObjects.add(obj);
            }
        } else {
            for (T obj : objects) {
                if (null == obj) continue;
                resetPolicy.reset(obj);
                if (freeObjects.size() >= poolSize) continue;
                freeObjects.add(obj);
            }
        }
    }

    @Override
    public void clear() {
        this.freeObjects.clear();
    }
}

