/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.io.ArrayPool;
import cn.wjybxx.base.io.ArrayPoolBuilder;
import cn.wjybxx.base.io.ArrayPoolCore;
import java.lang.reflect.Array;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class SimpleArrayPool<T>
implements ArrayPool<T> {
    private final Class<T> arrayType;
    private final int defCapacity;
    private final int maxCapacity;
    private final boolean clear;
    private final int poolSize;
    private final TreeSet<ArrayPoolCore.Node<T>> freeArrays;
    private final Consumer<T> clearHandler;
    private long sequence = 1L;

    public SimpleArrayPool(ArrayPoolBuilder.SimpleArrayPoolBuilder<T> builder) {
        this(builder.getArrayType(), builder.getPoolSize(), builder.getDefCapacity(), builder.getMaxCapacity(), builder.isClear());
    }

    public SimpleArrayPool(Class<T> arrayType, int poolSize, int defCapacity, int maxCapacity) {
        this(arrayType, poolSize, defCapacity, maxCapacity, false);
    }

    public SimpleArrayPool(Class<T> arrayType, int poolSize, int defCapacity, int maxCapacity, boolean clear) {
        if (arrayType.getComponentType() == null) {
            throw new IllegalArgumentException("arrayType");
        }
        if (defCapacity <= 0 || maxCapacity < 0 || poolSize < 0) {
            throw new IllegalArgumentException();
        }
        this.arrayType = arrayType;
        this.poolSize = poolSize;
        this.defCapacity = defCapacity;
        this.maxCapacity = maxCapacity;
        this.clear = clear;
        this.clearHandler = ArrayPoolCore.findClearHandler(arrayType);
        this.freeArrays = new TreeSet(ArrayPoolCore.COMPARATOR);
    }

    @Override
    @Nonnull
    public T acquire() {
        ArrayPoolCore.Node<T> minNode = this.freeArrays.pollFirst();
        if (minNode != null) {
            return minNode.array();
        }
        return (T)Array.newInstance(this.arrayType.getComponentType(), this.defCapacity);
    }

    @Override
    public T acquire(int minimumLength) {
        return this.acquire(minimumLength, false);
    }

    @Override
    public T acquire(int minimumLength, boolean clear) {
        ArrayPoolCore.Node ceilingNode = this.freeArrays.ceiling(new ArrayPoolCore.LengthNode(minimumLength));
        if (ceilingNode != null) {
            this.freeArrays.remove(ceilingNode);
            Object array = ceilingNode.array();
            if (!this.clear && clear) {
                this.clearHandler.accept(array);
            }
            return array;
        }
        return (T)Array.newInstance(this.arrayType.getComponentType(), minimumLength);
    }

    @Override
    public void release(T array) {
        this.releaseImpl(array, this.clear);
    }

    @Override
    public void release(T array, boolean clear) {
        this.releaseImpl(array, this.clear || clear);
    }

    private void releaseImpl(T array, boolean clear) {
        int length = Array.getLength(array);
        if (this.freeArrays.size() < this.poolSize && length <= this.maxCapacity) {
            if (clear) {
                this.clearHandler.accept(array);
            }
            this.freeArrays.add(new ArrayPoolCore.ArrayNode<T>(array, length, this.sequence++));
        }
    }

    @Override
    public void clear() {
        this.freeArrays.clear();
    }
}

