/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.MathCommon;
import cn.wjybxx.base.pool.ObjectPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class StringBuilderPool
implements ObjectPool<StringBuilder> {
    private final int poolSize;
    private final int initCapacity;
    private final int maxCapacity;
    private final List<StringBuilder> freeBuilders;

    public StringBuilderPool(int poolSize, int initCapacity) {
        this(poolSize, initCapacity, Integer.MAX_VALUE);
    }

    public StringBuilderPool(int poolSize, int initCapacity, int maxCapacity) {
        if (poolSize < 0 || initCapacity < 0 || maxCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.poolSize = poolSize;
        this.initCapacity = initCapacity;
        this.maxCapacity = maxCapacity;
        this.freeBuilders = new ArrayList<StringBuilder>(MathCommon.clamp(poolSize, 0, 10));
    }

    @Override
    @Nonnull
    public StringBuilder rent() {
        int size = this.freeBuilders.size();
        if (size > 0) {
            return this.freeBuilders.remove(size - 1);
        }
        return new StringBuilder(this.initCapacity);
    }

    @Override
    public void returnOne(StringBuilder builder) {
        Objects.requireNonNull(builder);
        if (this.freeBuilders.size() < this.poolSize && builder.length() <= this.maxCapacity) {
            builder.setLength(0);
            this.freeBuilders.add(builder);
        }
    }

    @Override
    public void clear() {
        this.freeBuilders.clear();
    }
}

