/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.PropertiesUtils;
import cn.wjybxx.base.io.StringBuilderPool;
import cn.wjybxx.base.pool.ObjectPool;
import java.util.Properties;
import javax.annotation.Nonnull;

public class LocalStringBuilderPool
implements ObjectPool<StringBuilder> {
    public static final LocalStringBuilderPool INSTANCE = new LocalStringBuilderPool();
    private static final int POOL_SIZE;
    private static final int INIT_CAPACITY;
    private static final int MAX_CAPACITY;
    private static final ThreadLocal<StringBuilderPool> THREAD_LOCAL_INST;

    @Override
    @Nonnull
    public StringBuilder rent() {
        return THREAD_LOCAL_INST.get().rent();
    }

    @Override
    public void returnOne(StringBuilder builder) {
        THREAD_LOCAL_INST.get().returnOne(builder);
    }

    @Override
    public void clear() {
    }

    public static StringBuilderPool localInst() {
        return THREAD_LOCAL_INST.get();
    }

    static {
        Properties properties = System.getProperties();
        POOL_SIZE = PropertiesUtils.getInt(properties, "Wjybxx.Commons.IO.LocalStringBuilderPool.PoolSize", 8);
        INIT_CAPACITY = PropertiesUtils.getInt(properties, "Wjybxx.Commons.IO.LocalStringBuilderPool.InitCapacity", 4096);
        MAX_CAPACITY = PropertiesUtils.getInt(properties, "Wjybxx.Commons.IO.LocalStringBuilderPool.MaxCapacity", Integer.MAX_VALUE);
        THREAD_LOCAL_INST = ThreadLocal.withInitial(() -> new StringBuilderPool(POOL_SIZE, INIT_CAPACITY));
    }
}

