/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.ex;

import cn.wjybxx.base.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class ExceptionUtils {
    public static Throwable getRootCause(Throwable throwable) {
        List<Throwable> list = ExceptionUtils.getThrowableList(throwable);
        return list.isEmpty() ? null : list.getLast();
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>(4);
        while (throwable != null && !CollectionUtils.containsRef(list, (Object)throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return list;
    }

    public static boolean isChecked(Throwable throwable) {
        return !(throwable instanceof Error) && !(throwable instanceof RuntimeException);
    }

    public static boolean isUnchecked(Throwable throwable) {
        return throwable instanceof Error || throwable instanceof RuntimeException;
    }

    public static <R> R rethrow(Throwable throwable) {
        return ExceptionUtils.throwAsUncheckedException(throwable);
    }

    public static <T extends Throwable> T throwUnchecked(T throwable) {
        if (ExceptionUtils.isUnchecked(throwable)) {
            return (T)((Throwable)ExceptionUtils.throwAsUncheckedException(throwable));
        }
        return throwable;
    }

    private static <R, T extends Throwable> R throwAsUncheckedException(Throwable throwable) throws T {
        throw throwable;
    }
}

