/*
 * Decompiled with CFR 0.152.
 */
package cn.wjee.starter.xxl.scanner;

import cn.wjee.commons.lang.StringUtils;
import cn.wjee.commons.lock.DistributedLock;
import cn.wjee.starter.xxl.XxlJobProperties;
import cn.wjee.starter.xxl.annotation.EnableXxlAutoReg;
import cn.wjee.starter.xxl.annotation.XxlAutoReg;
import cn.wjee.starter.xxl.client.XxlAdminClient;
import cn.wjee.starter.xxl.client.request.ExecutorAddRequest;
import cn.wjee.starter.xxl.client.request.JobAddRequest;
import cn.wjee.starter.xxl.client.response.ExecutorPageResponse;
import cn.wjee.starter.xxl.client.response.GroupPageResponse;
import cn.wjee.starter.xxl.client.response.JobPageResponse;
import cn.wjee.starter.xxl.client.response.LoginResponse;
import cn.wjee.starter.xxl.enums.GlueType;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class XxlJobAutoScanner
implements ApplicationContextAware,
SmartInitializingSingleton {
    protected static final Logger log = LoggerFactory.getLogger(XxlJobAutoScanner.class);
    private static ApplicationContext applicationContext;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final XxlAdminClient xxlAdminClient;
    private final DistributedLock distributedLock;
    private final String appName;

    XxlJobAutoScanner(XxlJobProperties xxlJobProperties, DistributedLock distributedLock, String appName) {
        this.xxlAdminClient = new XxlAdminClient(xxlJobProperties.getUrl(), xxlJobProperties.getUsername(), xxlJobProperties.getPassword());
        this.distributedLock = distributedLock;
        this.appName = appName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        XxlJobAutoScanner.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void afterSingletonsInstantiated() {
        Lock tempLocked;
        boolean lockEnabled;
        block14: {
            block13: {
                block12: {
                    boolean bl = lockEnabled = this.distributedLock != null;
                    if (!lockEnabled) {
                        log.warn(">>>>> \u5206\u5e03\u5f0f\u9501 [DistributedLock] \u65e0\u53ef\u7528\u5b9e\u73b0, \u9ed8\u8ba4\u4f7f\u7528\u65e0\u9501\u65b9\u5f0f\u6ce8\u518cJOB, \u591a\u8282\u70b9\u540c\u65f6\u542f\u52a8\u6709\u91cd\u590d\u6ce8\u518c\u7684\u98ce\u9669~");
                    }
                    tempLocked = null;
                    if (!this.started.compareAndSet(false, true)) return;
                    try {
                        String lockKey = this.appName + ":xxl-job:auto-register";
                        if (lockEnabled) {
                            tempLocked = this.distributedLock.lock(lockKey, 5000L, 300000L);
                        }
                        if (lockEnabled && tempLocked == null) {
                            log.info(">>>>>>>>>>> Xxl\u52a0\u9501\u5931\u8d25, \u5ffd\u7565\u81ea\u52a8\u6ce8\u518c\uff01\uff01\uff01\uff01");
                            if (!lockEnabled) return;
                            if (tempLocked == null) return;
                            break block12;
                        }
                        if (lockEnabled) {
                            this.scanAutoRegXxlJobConfig(applicationContext);
                            if (!lockEnabled) return;
                            break block13;
                        }
                        this.scanAutoRegXxlJobConfig(applicationContext);
                        if (!lockEnabled) return;
                        break block14;
                    }
                    catch (Exception e) {
                        log.error("XxlJobAutoScanner afterSingletonsInstantiated fail", (Throwable)e);
                        return;
                    }
                }
                this.distributedLock.unlock(tempLocked);
                return;
            }
            if (tempLocked == null) return;
            this.distributedLock.unlock(tempLocked);
            return;
        }
        if (tempLocked == null) return;
        this.distributedLock.unlock(tempLocked);
        return;
        finally {
            if (lockEnabled && tempLocked != null) {
                this.distributedLock.unlock(tempLocked);
            }
        }
    }

    private synchronized void scanAutoRegXxlJobConfig(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            return;
        }
        LoginResponse login = this.xxlAdminClient.login(3);
        if (login == null || !login.isSuccess()) {
            return;
        }
        String[] beanDefinitionNames = applicationContext.getBeanNamesForType(Object.class, false, true);
        boolean groupSuccess = this.registerGroupAndExecutor(login, beanDefinitionNames);
        if (groupSuccess) {
            this.scanAndRegisterJob(login, beanDefinitionNames);
        }
    }

    private void scanAndRegisterJob(LoginResponse loginResponse, String[] beanDefinitionNames) {
        try {
            HashMap finalAnnotatedMethods = new HashMap();
            for (String beanDefinitionName : beanDefinitionNames) {
                Object bean = applicationContext.getBean(beanDefinitionName);
                Map annotatedMethods = null;
                try {
                    annotatedMethods = MethodIntrospector.selectMethods(bean.getClass(), method -> (XxlJob)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, XxlJob.class));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (annotatedMethods == null || annotatedMethods.isEmpty()) continue;
                finalAnnotatedMethods.putAll(annotatedMethods);
            }
            ConcurrentHashMap<String, Integer> executorCacheMap = new ConcurrentHashMap<String, Integer>();
            for (Map.Entry methodXxlJobEntry : finalAnnotatedMethods.entrySet()) {
                Method executeMethod = (Method)methodXxlJobEntry.getKey();
                XxlJob xxlJob = (XxlJob)methodXxlJobEntry.getValue();
                this.pushXxlJobHandler(loginResponse, executeMethod, xxlJob, executorCacheMap);
            }
        }
        catch (BeansException beansException) {
            // empty catch block
        }
    }

    private boolean registerGroupAndExecutor(LoginResponse loginResponse, String[] beanDefinitionNames) {
        try {
            LinkedHashSet<Class> allHasTypes = new LinkedHashSet<Class>();
            LinkedHashSet<Class> onlyHasTypes = new LinkedHashSet<Class>();
            for (String beanDefinitionName : beanDefinitionNames) {
                Object bean = applicationContext.getBean(beanDefinitionName);
                LinkedHashSet<Class> handlerTypes = new LinkedHashSet<Class>();
                Class specificHandlerType = null;
                if (!Proxy.isProxyClass(bean.getClass())) {
                    specificHandlerType = ClassUtils.getUserClass(bean.getClass());
                    handlerTypes.add(specificHandlerType);
                }
                handlerTypes.addAll(ClassUtils.getAllInterfacesForClassAsSet(bean.getClass()));
                for (Class currentHandlerType : handlerTypes) {
                    Class targetClass = specificHandlerType != null ? specificHandlerType : currentHandlerType;
                    boolean xxlAutoPresent = targetClass.isAnnotationPresent(EnableXxlAutoReg.class);
                    boolean springBootPresent = targetClass.isAnnotationPresent(SpringBootApplication.class);
                    if (xxlAutoPresent && springBootPresent) {
                        allHasTypes.add(targetClass);
                        continue;
                    }
                    if (!xxlAutoPresent) continue;
                    onlyHasTypes.add(targetClass);
                }
            }
            ArrayList<Class> annotatedClzList = new ArrayList<Class>(allHasTypes);
            annotatedClzList.addAll(onlyHasTypes);
            Class finalAnnotatedClz = annotatedClzList.stream().findFirst().orElse(null);
            if (finalAnnotatedClz == null) {
                return false;
            }
            EnableXxlAutoReg annotation = finalAnnotatedClz.getAnnotation(EnableXxlAutoReg.class);
            if (!annotation.auto()) {
                return true;
            }
            String bizGroup = annotation.group();
            String executorName = annotation.executor();
            return this.pushXxlGroupExecutor(loginResponse, bizGroup, executorName);
        }
        catch (BeansException ignored) {
            return false;
        }
    }

    private boolean pushXxlGroupExecutor(LoginResponse loginResponse, String group, String executorName) {
        try {
            AtomicInteger alreadyRegGroupId = new AtomicInteger(0);
            this.checkGroup(loginResponse, group, (flag, groupId) -> alreadyRegGroupId.set(flag != false ? groupId : 0));
            List<String> cookie = loginResponse.getCookie();
            if (alreadyRegGroupId.get() <= 0) {
                boolean b = this.xxlAdminClient.addGroup(cookie, group);
                log.info(">>>>>>>>>>> xxl-job \u81ea\u52a8\u6ce8\u518c\u4e1a\u52a1\u7ec4 [{}]{}", (Object)group, (Object)(b ? "\u6210\u529f" : "\u5931\u8d25!!!!"));
                if (!b) {
                    return false;
                }
                this.checkGroup(loginResponse, group, (flag, groupId) -> alreadyRegGroupId.set(flag != false ? groupId : 0));
            } else {
                log.info(">>>>>>>>>>> xxl-job \u81ea\u52a8\u6ce8\u518c\u4e1a\u52a1\u7ec4 [{}], \u68c0\u6d4b\u5df2\u5b58\u5728\u5ffd\u7565", (Object)group);
            }
            if (alreadyRegGroupId.get() <= 0) {
                return false;
            }
            AtomicInteger alreadyRegisterExecutor = new AtomicInteger(0);
            this.checkExecutor(loginResponse, executorName, (flag, executorId) -> alreadyRegisterExecutor.set(flag != false ? executorId : 0));
            if (alreadyRegisterExecutor.get() <= 0) {
                ExecutorAddRequest executorAddRequest = new ExecutorAddRequest().setAppName(this.appName).setTitle(executorName).setBusId(alreadyRegGroupId.get()).setAddressType(0);
                boolean result = this.xxlAdminClient.addExecutor(cookie, executorAddRequest);
                log.info(">>>>>>>>>>> xxl-job \u81ea\u52a8\u6ce8\u518c\u6267\u884c\u5668 [{}]{}", (Object)executorName, (Object)(result ? "\u6210\u529f" : "\u5931\u8d25!!!!"));
                if (result) {
                    this.checkExecutor(loginResponse, executorName, (flag, executorId) -> alreadyRegisterExecutor.set(flag != false ? executorId : 0));
                }
            } else {
                log.info(">>>>>>>>>>> xxl-job \u81ea\u52a8\u6ce8\u518c\u6267\u884c\u5668 [{}], \u68c0\u6d4b\u5df2\u5b58\u5728\u5ffd\u7565", (Object)executorName);
            }
            return alreadyRegisterExecutor.get() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void checkGroup(LoginResponse loginResponse, String group, BiConsumer<Boolean, Integer> consumer) {
        try {
            GroupPageResponse groupPage;
            List<String> cookie = loginResponse.getCookie();
            int groupId = 0;
            boolean hasAddGroup = false;
            int size = 100;
            int pageNo = 1;
            do {
                List<GroupPageResponse.GroupInfo> groupInfos;
                GroupPageResponse.GroupInfo groupInfo;
                if ((groupInfo = (GroupPageResponse.GroupInfo)((List)Optional.ofNullable(groupInfos = (groupPage = this.xxlAdminClient.getGroupPage(cookie, pageNo, 100)) != null ? groupPage.getData() : null).orElse(new ArrayList())).stream().filter(g -> g.getName().equals(group)).findFirst().orElse(null)) != null) {
                    hasAddGroup = true;
                    groupId = groupInfo.getId();
                    continue;
                }
                ++pageNo;
            } while (groupPage != null && groupPage.getData() != null && groupPage.getData().size() == 100);
            consumer.accept(hasAddGroup, groupId);
        }
        catch (Exception e) {
            consumer.accept(false, null);
        }
    }

    private void checkExecutor(LoginResponse loginResponse, String executorName, BiConsumer<Boolean, Integer> consumer) {
        ExecutorPageResponse.ExecutorInfo executorInfo;
        ExecutorPageResponse executorPage = this.xxlAdminClient.getExecutorPage(loginResponse.getCookie(), this.appName);
        List<Object> executorList = new ArrayList();
        if (executorPage != null && executorPage.getData() != null) {
            executorList = executorPage.getData();
        }
        consumer.accept((executorInfo = (ExecutorPageResponse.ExecutorInfo)executorList.stream().filter(s -> s.getAppName().equals(this.appName)).filter(s -> s.getTitle().equals(executorName)).findFirst().orElse(null)) != null, executorInfo != null ? executorInfo.getId() : 0);
    }

    private void pushXxlJobHandler(LoginResponse loginResponse, Method executeMethod, XxlJob xxlJob, ConcurrentHashMap<String, Integer> executorCacheMap) {
        try {
            boolean processReg;
            List addedJobList;
            if (!executeMethod.isAnnotationPresent(XxlAutoReg.class)) {
                return;
            }
            XxlAutoReg xxlAutoReg = executeMethod.getAnnotation(XxlAutoReg.class);
            String executorName = xxlAutoReg.executor();
            if (StringUtils.isAnyBlank((String[])new String[]{executorName, xxlAutoReg.jobName()})) {
                return;
            }
            Integer executorId = executorCacheMap.get(executorName);
            if (executorId == null) {
                AtomicInteger registeredExecutorId = new AtomicInteger(0);
                this.checkExecutor(loginResponse, executorName, (flag, tempExecutorId) -> registeredExecutorId.set(flag != false ? tempExecutorId : 0));
                executorCacheMap.put(executorName, registeredExecutorId.get());
                executorId = executorCacheMap.get(executorName);
            }
            if (executorId == null || executorId <= 0) {
                return;
            }
            ArrayList<JobPageResponse.JobInfo> jobInfoList = new ArrayList<JobPageResponse.JobInfo>();
            int pageNo = 1;
            while (true) {
                JobPageResponse jobPage;
                ArrayList tempJobInfoList;
                if (CollectionUtils.isEmpty((Collection)(addedJobList = (List)Optional.ofNullable(tempJobInfoList = (jobPage = this.xxlAdminClient.getJobPage(loginResponse.getCookie(), executorId, null, pageNo, 100)) != null ? jobPage.getData() : new ArrayList()).orElse(new ArrayList()))) || addedJobList.size() < 100) break;
                jobInfoList.addAll(addedJobList);
                ++pageNo;
            }
            jobInfoList.addAll(addedJobList);
            GlueType glueType = xxlAutoReg.glueType();
            if (glueType == GlueType.BEAN) {
                String jobHandler = xxlJob.value();
                processReg = jobInfoList.stream().noneMatch(s -> s.getExecutorHandler().equals(jobHandler));
            } else {
                processReg = jobInfoList.stream().noneMatch(s -> s.getJobDesc().equals(xxlAutoReg.jobName()));
            }
            if (!processReg) {
                log.info(">>>>>>>>>>> xxl-job \u81ea\u52a8\u6ce8\u518c\u4efb\u52a1 [{}], \u68c0\u6d4b\u5df2\u5b58\u5728\u5ffd\u7565", (Object)xxlAutoReg.jobName());
                return;
            }
            JobAddRequest jobAddRequest = new JobAddRequest().setJobExecutor(executorId).setJobDesc(xxlAutoReg.jobName()).setAuthor(xxlAutoReg.author()).setAlarmEmail(xxlAutoReg.email()).setScheduleType(xxlAutoReg.scheduleType()).setScheduleConf(xxlAutoReg.corn()).setGlueType(xxlAutoReg.glueType()).setGlueSource(xxlAutoReg.glueSource()).setGlueRemark(xxlAutoReg.glueRemark()).setExecutorHandler(xxlJob.value()).setExecutorParam(xxlAutoReg.jobParam()).setExecutorRouteStrategy(xxlAutoReg.routeType()).setMisfireStrategy(xxlAutoReg.misFireStrategy()).setExecutorBlockStrategy(xxlAutoReg.blockStrategy()).setChildJobId("").setExecutorTimeout(xxlAutoReg.executorTimeout()).setExecutorFailRetryCount(xxlAutoReg.executorFailRetryCount());
            if (this.xxlAdminClient.addJob(loginResponse.getCookie(), jobAddRequest)) {
                log.info(">>>>>>>>>>> xxl-job \u81ea\u52a8\u6ce8\u518c\u4efb\u52a1 [{}]\u6210\u529f", (Object)jobAddRequest.getJobDesc());
                JobPageResponse.JobInfo jobInfo = new JobPageResponse.JobInfo();
                jobInfo.setJobDesc(xxlAutoReg.jobName());
                jobInfo.setExecutorHandler(glueType == GlueType.BEAN ? xxlJob.value() : "");
                jobInfoList.add(jobInfo);
            } else {
                log.info(">>>>>>>>>>> xxl-job \u81ea\u52a8\u6ce8\u518c\u4efb\u52a1 [{}]\u5931\u8d25\uff01\uff01\uff01\uff01", (Object)jobAddRequest.getJobDesc());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

