/*
 * Decompiled with CFR 0.152.
 */
package cn.wjee.starter.xxl.client;

import cn.wjee.commons.collection.CollectionUtils;
import cn.wjee.commons.enums.ApiStatusEnum;
import cn.wjee.commons.extra.lang.JacksonUtils;
import cn.wjee.commons.lang.StringUtils;
import cn.wjee.starter.xxl.client.request.ExecutorAddRequest;
import cn.wjee.starter.xxl.client.request.JobAddRequest;
import cn.wjee.starter.xxl.client.response.ExecutorPageResponse;
import cn.wjee.starter.xxl.client.response.GroupPageResponse;
import cn.wjee.starter.xxl.client.response.JobPageResponse;
import cn.wjee.starter.xxl.client.response.LoginResponse;
import cn.wjee.starter.xxl.client.response.XxlResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class XxlAdminClient {
    private final String adminUrl;
    private final String username;
    private final String password;
    private final RestTemplate restTemplate = XxlAdminClient.getRestTemplate();

    private static RestTemplate getRestTemplate() {
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        simpleClientHttpRequestFactory.setConnectTimeout(1000);
        simpleClientHttpRequestFactory.setReadTimeout(3000);
        return new RestTemplate((ClientHttpRequestFactory)simpleClientHttpRequestFactory);
    }

    public XxlAdminClient(String adminUrl, String username, String password) {
        this.adminUrl = adminUrl;
        this.username = username;
        this.password = password;
    }

    public LoginResponse login(int tryTimes) {
        try {
            LoginResponse response = new LoginResponse();
            if (tryTimes < 1) {
                return response;
            }
            String url = this.adminUrl + "/login";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            params.add((Object)"userName", (Object)this.username);
            params.add((Object)"password", (Object)this.password);
            HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
            ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            String respBody = (String)exchange.getBody();
            XxlResponse xxlResponse = (XxlResponse)JacksonUtils.fromJson((String)respBody, (TypeReference)new TypeReference<XxlResponse<Void>>(){});
            if (xxlResponse == null || !xxlResponse.isSuccess()) {
                return response;
            }
            List cookies = exchange.getHeaders().get((Object)"Set-Cookie");
            response.setCookie(cookies);
            response.setSuccess(true);
            return response;
        }
        catch (Exception e) {
            return this.login(--tryTimes);
        }
    }

    public GroupPageResponse getGroupPage(List<String> cookie, Integer pageNo, Integer pageSize) {
        try {
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            params.add((Object)"start", (Object)((pageNo - 1) * pageSize));
            params.add((Object)"length", (Object)pageSize);
            String respBody = this.postForm(this.adminUrl + "/jobbusgroup/pageList", (MultiValueMap<String, Object>)params, cookie);
            return (GroupPageResponse)JacksonUtils.fromJson((String)respBody, (TypeReference)new TypeReference<GroupPageResponse>(){});
        }
        catch (Exception e) {
            return null;
        }
    }

    public ExecutorPageResponse getExecutorPage(List<String> cookie, String appName) {
        try {
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            params.add((Object)"appname", (Object)appName);
            params.add((Object)"title", (Object)"");
            params.add((Object)"start", (Object)0);
            params.add((Object)"length", (Object)10);
            String respBody = this.postForm(this.adminUrl + "/jobgroup/pageList", (MultiValueMap<String, Object>)params, cookie);
            return (ExecutorPageResponse)JacksonUtils.fromJson((String)respBody, (TypeReference)new TypeReference<ExecutorPageResponse>(){});
        }
        catch (Exception e) {
            return null;
        }
    }

    public JobPageResponse getJobPage(List<String> cookie, Integer executorId, String jobHandler, Integer pageNo, Integer pageSize) {
        try {
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            params.add((Object)"jobGroup", (Object)(executorId != null && executorId >= 0 ? executorId : 0));
            params.add((Object)"executorHandler", (Object)StringUtils.getValue((String)jobHandler));
            params.add((Object)"start", (Object)((pageNo - 1) * pageSize));
            params.add((Object)"length", (Object)pageSize);
            String respBody = this.postForm(this.adminUrl + "/jobinfo/pageList", (MultiValueMap<String, Object>)params, cookie);
            return (JobPageResponse)JacksonUtils.fromJson((String)respBody, (TypeReference)new TypeReference<JobPageResponse>(){});
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean addGroup(List<String> cookie, String groupName) {
        try {
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            params.add((Object)"name", (Object)groupName);
            String s = this.postForm(this.adminUrl + "/jobbusgroup/add", (MultiValueMap<String, Object>)params, cookie);
            JsonNode root = JacksonUtils.fromJson((String)s);
            String code = JacksonUtils.getChildNodeStringValue((JsonNode)root, (String)"code");
            return ApiStatusEnum.SUCCESS.getStringCode().equals(code);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean addExecutor(List<String> cookie, ExecutorAddRequest request) {
        try {
            String s = this.postForm(this.adminUrl + "/jobgroup/save", request.toMap(), cookie);
            JsonNode root = JacksonUtils.fromJson((String)s);
            String code = JacksonUtils.getChildNodeStringValue((JsonNode)root, (String)"code");
            return ApiStatusEnum.SUCCESS.getStringCode().equals(code);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean addJob(List<String> cookie, JobAddRequest request) {
        try {
            String s = this.postForm(this.adminUrl + "/jobinfo/add", request.toMap(), cookie);
            JsonNode root = JacksonUtils.fromJson((String)s);
            String code = JacksonUtils.getChildNodeStringValue((JsonNode)root, (String)"code");
            return ApiStatusEnum.SUCCESS.getStringCode().equals(code);
        }
        catch (Exception e) {
            return false;
        }
    }

    private String postForm(String url, MultiValueMap<String, Object> params, List<String> cookie) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        if (CollectionUtils.isNotEmpty(cookie)) {
            headers.add("Cookie", StringUtils.join(cookie, (String)";"));
        }
        HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class, new Object[0]);
        return (String)exchange.getBody();
    }
}

