/*
 * Decompiled with CFR 0.152.
 */
package cn.wjee.starter.xxl;

import cn.wjee.commons.lang.StringUtils;
import cn.wjee.starter.xxl.XxlJobProperties;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={XxlJobProperties.class})
@ConditionalOnClass(value={XxlJobSpringExecutor.class})
@ConditionalOnProperty(prefix="wjee.xxl-job", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class XxlJobConfiguration {
    @Bean
    public XxlJobSpringExecutor xxlJobExecutor(XxlJobProperties xxlJobProperties, @Value(value="${spring.application.name}") String appName) {
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        xxlJobSpringExecutor.setAdminAddresses(xxlJobProperties.getUrl());
        xxlJobSpringExecutor.setAppname(StringUtils.getValue((String)xxlJobProperties.getAppName(), (String)appName));
        xxlJobSpringExecutor.setIp(xxlJobProperties.getIp());
        xxlJobSpringExecutor.setPort(xxlJobProperties.getPort());
        xxlJobSpringExecutor.setAccessToken(xxlJobProperties.getAccessToken());
        xxlJobSpringExecutor.setLogPath(xxlJobProperties.getLogPath());
        xxlJobSpringExecutor.setLogRetentionDays(xxlJobProperties.getLogRetentionDays());
        return xxlJobSpringExecutor;
    }
}

