package cn.wjee.starter.xxl.scanner;

import cn.wjee.commons.WJeeVar;
import cn.wjee.commons.lock.DistributedLock;
import cn.wjee.starter.xxl.XxlJobProperties;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * XXL自动注册任务配置
 *
 * @author listening
 */
@Configuration
@ConditionalOnClass(XxlJobSpringExecutor.class)
@EnableConfigurationProperties(XxlJobProperties.class)
@AutoConfigureAfter({RedisAutoConfiguration.class})
@ConditionalOnProperty(prefix = WJeeVar.NAMESPACE + ".xxl-job", name = "enabled", havingValue = "true")
public class XxlJobAutoScanConfiguration {
    /**
     * 主动扫描
     *
     * @param xxlJobProperties JOB参数
     * @param lockProvider     锁
     * @return 扫描器
     */
    @Bean
    @ConditionalOnMissingBean(XxlJobAutoScanner.class)
    public XxlJobAutoScanner getXxlJobAutoScanner(
        @Value("${spring.application.name}") String appName,
        XxlJobProperties xxlJobProperties, ObjectProvider<List<DistributedLock>> lockProvider) {
        DistributedLock distributedLock = Optional.ofNullable(lockProvider.getIfAvailable())
            .orElse(new ArrayList<>())
            .stream()
            .findFirst().orElse(null);
        return new XxlJobAutoScanner(xxlJobProperties, distributedLock, appName);
    }
}
