package cn.wjee.starter.xxl.client.request;

import cn.wjee.starter.xxl.enums.*;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/**
 * 添加任务
 *
 * @author listening
 */
@Data
@Accessors(chain = true)
public class JobAddRequest {
    /**
     * 执行器ID
     */
    private Integer jobExecutor;
    /**
     * 任务描述
     */
    private String jobDesc = "";
    /**
     * 负责人
     */
    private String author = "";
    /**
     * 报警邮箱
     */
    private String alarmEmail = "";
    /**
     * 调度类型
     */
    private ScheduleType scheduleType = ScheduleType.CRON;
    /**
     * Corn表达式 或 执行间隔
     */
    private String scheduleConf = "";
    /**
     * 运行模式
     */
    private GlueType glueType = GlueType.BEAN;
    /**
     * 执行JOB
     */
    private String executorHandler = "";
    /**
     * 执行参数
     */
    private String executorParam = "";
    /**
     * 路由策略
     */
    private RouteType executorRouteStrategy = RouteType.FIRST;
    /**
     * 子任务ID
     */
    private String childJobId = "";
    /**
     * 调度过期策略
     */
    private MisFireStrategy misfireStrategy = MisFireStrategy.DO_NOTHING;
    /**
     * 阻塞处理策略
     */
    private BlockStrategy executorBlockStrategy = BlockStrategy.SERIAL_EXECUTION;
    /**
     * 任务超时时间(默认0，大于0生效)
     */
    private Integer executorTimeout = 0;
    /**
     * 失败重试次数(默认0，大于0生效)
     */
    private Integer executorFailRetryCount = 0;
    /**
     * Glue代码备注
     */
    private String glueRemark = "";
    /**
     * Glue代码
     */
    private String glueSource = "";

    public MultiValueMap<String, Object> toMap() {
        MultiValueMap<String, Object> params = new LinkedMultiValueMap<>();
        params.add("jobGroup", getJobExecutor());
        params.add("jobDesc", getJobDesc());
        params.add("author", getAuthor());
        params.add("alarmEmail", getAlarmEmail());

        ScheduleType scheduleType = getScheduleType();
        params.add("scheduleType", scheduleType.name());
        if (scheduleType == ScheduleType.NONE) {
            params.add("scheduleConf", "");
        } else {
            params.add("scheduleConf", getScheduleConf());
        }

        GlueType glueType = getGlueType();
        params.add("glueType", glueType.name());
        if (glueType == GlueType.BEAN) {
            params.add("executorHandler", getExecutorHandler());
        } else {
            params.add("executorHandler", "");
        }

        params.add("executorParam", getExecutorParam());
        params.add("executorRouteStrategy", getExecutorRouteStrategy().name());
        params.add("childJobId", getChildJobId());
        params.add("misfireStrategy", getMisfireStrategy().name());
        params.add("executorBlockStrategy", getExecutorBlockStrategy().name());
        params.add("executorTimeout", getExecutorTimeout());
        params.add("executorFailRetryCount", getExecutorFailRetryCount());
        params.add("glueRemark", getGlueRemark());
        params.add("glueSource", getGlueSource());
        return params;
    }
}
