package cn.wjee.starter.xxl.client.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/**
 * 添加任务
 *
 * @author listening
 */
@Data
@Accessors(chain = true)
public class ExecutorAddRequest {
    /**
     * 业务组
     */
    private Integer busId;
    /**
     * 注册方式(0-自动注册,1-手动录入)
     */
    private Integer addressType = 0;
    /**
     * 项目名标识
     */
    @JsonProperty("appname")
    private String appName = "";
    /**
     * 执行器名称
     */
    private String title = "";
    /**
     * 机器地址(逗号分割)
     */
    private String addressList = "";

    public MultiValueMap<String, Object> toMap() {
        MultiValueMap<String, Object> params = new LinkedMultiValueMap<>();
        params.add("busId", getBusId());
        params.add("addressType", getAddressType());
        params.add("addressList", getAddressList());
        params.add("appname", getAppName());
        params.add("title", getTitle());
        return params;
    }
}
