package cn.wjee.starter.xxl.annotation;

import cn.wjee.starter.xxl.enums.*;

import java.lang.annotation.*;

/**
 * XXL任务自动注册注解
 *
 * @author listening
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface XxlAutoReg {
    /**
     * 执行器名称
     *
     * @return String
     */
    String executor();

    /**
     * 任务描述
     *
     * @return String
     */
    String jobName();

    /**
     * 负责人
     *
     * @return String
     */
    String author();

    /**
     * 报警邮箱
     *
     * @return String
     */
    String email();

    /**
     * 运行模式
     *
     * @return GlueType
     */
    GlueType glueType() default GlueType.BEAN;

    /**
     * Glue代码
     *
     * @return String
     */
    String glueSource() default "";

    /**
     * Glue备注
     *
     * @return String
     */
    String glueRemark() default "";

    /**
     * JobHandler(读XxlJob注解)
     *
     * @return String
     */
    String jobHandler();

    /**
     * 任务参数
     *
     * @return String
     */
    String jobParam() default "";

    /**
     * 调度类型
     *
     * @return ScheduleType
     */
    ScheduleType scheduleType();

    /**
     * CORN表达式
     *
     * @return String
     */
    String corn() default "";

    /**
     * 路由策略(默认第一个)
     *
     * @return RouteType
     */
    RouteType routeType() default RouteType.FIRST;

    /**
     * 过期策略(默认忽略)
     *
     * @return MisFireStrategy
     */
    MisFireStrategy misFireStrategy() default MisFireStrategy.DO_NOTHING;

    /**
     * 阻塞策略(默认串行)
     *
     * @return BlockStrategy
     */
    BlockStrategy blockStrategy() default BlockStrategy.SERIAL_EXECUTION;

    /**
     * 超时时间(秒),大于0生效
     *
     * @return int
     */
    int executorTimeout() default 0;

    /**
     * 失败重试次数,大于0生效
     *
     * @return int
     */
    int executorFailRetryCount() default 0;
}
