package cn.wjee.starter.xxl.annotation;

import org.springframework.context.annotation.Import;

import java.lang.annotation.*;

/**
 * 启动XxlJob自动注册Task
 *
 * @author listening
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Import(AutoScanImportSelector.class)
public @interface EnableXxlAutoReg {
    /**
     * 是否自动注册业务组 + 执行器
     *
     * @return boolean
     */
    boolean auto() default false;

    /**
     * 业务组名称
     *
     * @return String
     */
    String group();

    /**
     * 执行器名称
     *
     * @return String
     */
    String executor() default "";
}
