package cn.wjee.starter.xxl.api.response;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 任务列表返回
 *
 * @author listening
 */
@Data
public class JobPageResponse {
    /**
     * 筛选数量
     */
    private Integer recordsFiltered;
    /**
     * 记录总数
     */
    private Integer recordsTotal;
    /**
     * 执行器列表
     */
    private List<JobInfo> data = new ArrayList<>();

    @Data
    public static class JobInfo {
        /**
         * 执行器ID
         */
        private Integer id;
        /**
         * 业务组
         */
        private Integer busId;
        /**
         * 执行器ID
         */
        private String jobGroup;
        /**
         * 执行器名称
         */
        private String title;
        /**
         * 任务名称
         */
        private String jobDesc;
        /**
         * 任务执行方法
         */
        private String executorHandler;
        /**
         * 任务类型（BEAN）
         */
        private String glueType;
        /**
         * 联系人
         */
        private String author;
        /**
         * 报警邮箱
         */
        private String alarmEmail;
    }
}
