package cn.wjee.starter.xxl.api.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 执行器列表返回
 *
 * @author listening
 */
@Data
public class ExecutorPageResponse {
    /**
     * 成功查询
     */
    private boolean success = false;
    /**
     * 筛选数量
     */
    private Integer recordsFiltered;
    /**
     * 记录总数
     */
    private Integer recordsTotal;
    /**
     * 执行器列表
     */
    private List<ExecutorInfo> data = new ArrayList<>();

    @Data
    public static class ExecutorInfo {
        /**
         * 执行器ID
         */
        private Integer id;
        /**
         * 应用名称
         */
        @JsonProperty("appname")
        private String appName;
        /**
         * 执行器名称
         */
        private String title;
    }
}
