package cn.wjee.starter.xxl.annotation;

import cn.wjee.starter.xxl.scanner.XxlJobAutoScanConfiguration;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

/**
 * WJeeBoot 跟Configuration一起加载ImportSelector
 *
 * @author wjee
 */
public class AutoScanImportSelector implements ImportSelector {
    /**
     * 构建启动数组
     *
     * @param importingClassMetadata AnnotationMetadata
     * @return String[]
     */
    @Override
    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        return new String[]{
            XxlJobAutoScanConfiguration.class.getCanonicalName(),
        };
    }
}
