package cn.wjee.starter.xxl;

import cn.wjee.commons.WJeeVar;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * XXL配置参数
 *
 * @author listening
 */
@Data
@ConfigurationProperties(prefix = WJeeVar.NAMESPACE + ".xxl-job")
public class XxlJobProperties {
    /**
     * 是否启用
     */
    private boolean enabled = true;
    /**
     * 管理地址
     */
    private String url = "http://localhost:9999/xxl-job-admin";
    /**
     * 应用标识
     */
    private String appName = "";
    /**
     * IP
     */
    private String ip;
    /**
     * 端口(默认：9999)
     */
    private int port = 9999;
    /**
     * 认证Token
     */
    private String accessToken = "";
    /**
     * 认证账号
     */
    private String username = "";
    private String password = "";
    /**
     * 日志路径
     */
    private String logPath = "logs/xxl";
    /**
     * 日志保留天数(默认3天)
     */
    private int logRetentionDays = 3;
}
