/*
 * Decompiled with CFR 0.152.
 */
package cn.wjchang.common.validate.check;

import cn.wjchang.common.validate.check.RegexPattern;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckUtil {
    public static Boolean isNull(Object value, String express) {
        if (null != value) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean isNotNull(Object value, String express) {
        if (null == value) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean isEmpty(Object value, String express) {
        return CheckUtil.isNotEmpty(value, express) == false;
    }

    public static Boolean isNotEmpty(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (value instanceof String && "".equals(((String)value).trim())) {
            return Boolean.FALSE;
        }
        if (value instanceof Collection && ((Collection)value).size() == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean isTrue(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            try {
                return Boolean.parseBoolean((String)value);
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        return Boolean.FALSE;
    }

    public static Boolean isFalse(Object value, String express) {
        return CheckUtil.isTrue(value, express) == false;
    }

    public static Boolean isDate(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (express == null || "".equals(express)) {
            express = "yyyy-MM-dd";
        }
        if (value instanceof String) {
            String v = (String)value;
            try {
                LocalDate.parse(v, DateTimeFormatter.ofPattern(express));
                return Boolean.TRUE;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        if (value instanceof Date) {
            return Boolean.TRUE;
        }
        if (value instanceof LocalDate) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isDateTime(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (express == null || "".equals(express)) {
            express = "yyyy-MM-dd HH:mm:ss";
        }
        if (value instanceof String) {
            String v = (String)value;
            try {
                LocalDateTime.parse(v, DateTimeFormatter.ofPattern(express));
                return Boolean.TRUE;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        if (value instanceof Date) {
            return Boolean.TRUE;
        }
        if (value instanceof LocalDateTime) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isPast(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (express == null || "".equals(express)) {
            express = "yyyy-MM-dd HH:mm:ss";
        }
        if (value instanceof String) {
            String v = (String)value;
            try {
                LocalDateTime ldt = LocalDateTime.parse(v, DateTimeFormatter.ofPattern(express));
                return LocalDateTime.now().isAfter(ldt);
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        if (value instanceof Date) {
            return new Date().after((Date)value);
        }
        if (value instanceof LocalDate) {
            return LocalDate.now().isAfter((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return LocalDateTime.now().isAfter((LocalDateTime)value);
        }
        return Boolean.FALSE;
    }

    public static Boolean isFuture(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (express == null || "".equals(express)) {
            express = "yyyy-MM-dd HH:mm:ss";
        }
        if (value instanceof String) {
            String v = (String)value;
            try {
                LocalDateTime ldt = LocalDateTime.parse(v, DateTimeFormatter.ofPattern(express));
                return LocalDateTime.now().isBefore(ldt);
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        if (value instanceof Date) {
            return new Date().before((Date)value);
        }
        if (value instanceof LocalDate) {
            return LocalDate.now().isBefore((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return LocalDateTime.now().isBefore((LocalDateTime)value);
        }
        return Boolean.FALSE;
    }

    public static Boolean isToday(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (express == null || "".equals(express)) {
            express = "yyyy-MM-dd HH:mm:ss";
        }
        if (value instanceof String) {
            String v = (String)value;
            try {
                LocalDate ld = LocalDate.parse(v, DateTimeFormatter.ofPattern(express));
                return LocalDate.now().equals(ld);
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        if (value instanceof Date) {
            return new Date().equals(value);
        }
        if (value instanceof LocalDate) {
            return LocalDate.now().equals(value);
        }
        return Boolean.FALSE;
    }

    public static Boolean isNumber(Object value, String express) {
        if (null == value) {
            return Boolean.FALSE;
        }
        if (value instanceof Number) {
            return Boolean.TRUE;
        }
        return RegexPattern.NUMBER_CODE.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isGeneral(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.GENERAL.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isGeneralWithChinese(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.GENERAL_WITH_CHINESE.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isChinese(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.CHINESE.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isMobilePhone(Object value, String express) {
        if (null == value) {
            return Boolean.FALSE;
        }
        return RegexPattern.MOBILE.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isEmail(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (value instanceof String) {
            return RegexPattern.EMAIL.matcher(String.valueOf(value)).matches();
        }
        return Boolean.FALSE;
    }

    public static Boolean inRange(Object value, String rangeStr) {
        if (CheckUtil.isNull(value, rangeStr).booleanValue()) {
            return Boolean.FALSE;
        }
        if (null == rangeStr || "".equals(rangeStr)) {
            return Boolean.FALSE;
        }
        if (value instanceof Integer) {
            int begin = Integer.parseInt(rangeStr.split(",")[0]);
            int end = Integer.parseInt(rangeStr.split(",")[1]);
            int v = (Integer)value;
            return begin <= v && v <= end;
        }
        if (value instanceof Long) {
            long begin = Long.parseLong(rangeStr.split(",")[0]);
            long end = Long.parseLong(rangeStr.split(",")[1]);
            long v = (Long)value;
            return begin <= v && v <= end;
        }
        if (value instanceof Short) {
            short begin = Short.parseShort(rangeStr.split(",")[0]);
            short end = Short.parseShort(rangeStr.split(",")[1]);
            short v = (Short)value;
            return begin <= v && v <= end;
        }
        if (value instanceof Float) {
            float begin = Float.parseFloat(rangeStr.split(",")[0]);
            float end = Float.parseFloat(rangeStr.split(",")[1]);
            float v = ((Float)value).floatValue();
            return begin <= v && v <= end;
        }
        if (value instanceof Double) {
            double begin = Double.parseDouble(rangeStr.split(",")[0]);
            double end = Double.parseDouble(rangeStr.split(",")[1]);
            double v = (Double)value;
            return begin <= v && v <= end;
        }
        if (value instanceof BigDecimal) {
            BigDecimal begin = new BigDecimal(rangeStr.split(",")[0]);
            BigDecimal end = new BigDecimal(rangeStr.split(",")[1]);
            BigDecimal v = (BigDecimal)value;
            return begin.compareTo(v) <= 0 && v.compareTo(end) <= 0;
        }
        return Boolean.FALSE;
    }

    public static Boolean outRange(Object value, String rangeStr) {
        return CheckUtil.inRange(value, rangeStr) == false;
    }

    public static Boolean inLength(Object value, String rangeStr) {
        if (CheckUtil.isNull(value, rangeStr).booleanValue()) {
            return Boolean.FALSE;
        }
        if (null == rangeStr || "".equals(rangeStr)) {
            return Boolean.FALSE;
        }
        String splitter = ",";
        if (value instanceof String) {
            Integer begin = null;
            Integer end = null;
            begin = !rangeStr.contains(splitter) ? Integer.valueOf(0) : Integer.valueOf(rangeStr.split(splitter)[0]);
            end = begin == 0 ? Integer.valueOf(rangeStr) : Integer.valueOf(rangeStr.split(splitter)[1]);
            int v = ((String)value).length();
            return begin <= v && v <= end;
        }
        return Boolean.FALSE;
    }

    public static Boolean inEnum(Object value, String enumStr) {
        if (CheckUtil.isNull(value, null).booleanValue()) {
            return Boolean.FALSE;
        }
        if (null == enumStr || "".equals(enumStr)) {
            return Boolean.FALSE;
        }
        String[] array = enumStr.split(",");
        HashSet<String> set = new HashSet<String>(Arrays.asList(array));
        return set.contains(value.toString());
    }

    public static Boolean isGreaterThan(Object value, String express) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof Integer) {
            return (Integer)value > Integer.parseInt(express);
        }
        if (value instanceof Long) {
            return (Long)value > Long.parseLong(express);
        }
        if (value instanceof Short) {
            return (Short)value > Short.parseShort(express);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue() > Float.parseFloat(express);
        }
        if (value instanceof Double) {
            return (Double)value > Double.parseDouble(express);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(new BigDecimal(express)) > 0;
        }
        if (value instanceof String) {
            return ((String)value).length() > Integer.parseInt(express);
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() > Integer.parseInt(express);
        }
        return Boolean.FALSE;
    }

    public static Boolean isGreaterThanEqual(Object value, String express) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof Integer) {
            return (Integer)value >= Integer.parseInt(express);
        }
        if (value instanceof Long) {
            return (Long)value >= Long.parseLong(express);
        }
        if (value instanceof Short) {
            return (Short)value >= Short.parseShort(express);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue() >= Float.parseFloat(express);
        }
        if (value instanceof Double) {
            return (Double)value >= Double.parseDouble(express);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(new BigDecimal(express)) >= 0;
        }
        if (value instanceof String) {
            return ((String)value).length() >= Integer.parseInt(express);
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() >= Integer.parseInt(express);
        }
        return Boolean.FALSE;
    }

    public static Boolean isLessThan(Object value, String express) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof Integer) {
            return (Integer)value < Integer.parseInt(express);
        }
        if (value instanceof Long) {
            return (Long)value < Long.parseLong(express);
        }
        if (value instanceof Short) {
            return (Short)value < Short.parseShort(express);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue() < Float.parseFloat(express);
        }
        if (value instanceof Double) {
            return (Double)value < Double.parseDouble(express);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(new BigDecimal(express)) < 0;
        }
        if (value instanceof String) {
            return ((String)value).length() < Integer.parseInt(express);
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() < Integer.parseInt(express);
        }
        return Boolean.FALSE;
    }

    public static Boolean isLessThanEqual(Object value, String express) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof Integer) {
            return (Integer)value <= Integer.parseInt(express);
        }
        if (value instanceof Long) {
            return (Long)value <= Long.parseLong(express);
        }
        if (value instanceof Short) {
            return (Short)value <= Short.parseShort(express);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue() <= Float.parseFloat(express);
        }
        if (value instanceof Double) {
            return (Double)value <= Double.parseDouble(express);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(new BigDecimal(express)) <= 0;
        }
        if (value instanceof String) {
            return ((String)value).length() <= Integer.parseInt(express);
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() <= Integer.parseInt(express);
        }
        return Boolean.FALSE;
    }

    public static Boolean isNotEqual(Object value, String express) {
        return CheckUtil.isEqual(value, express) == false;
    }

    public static Boolean isEqual(Object value, String express) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof String) {
            return value.equals(express);
        }
        if (value instanceof Integer) {
            return value.equals(Integer.valueOf(express));
        }
        if (value instanceof Long) {
            return value.equals(Long.valueOf(express));
        }
        if (value instanceof Short) {
            return value.equals(Short.valueOf(express));
        }
        if (value instanceof Float) {
            return value.equals(Float.valueOf(express));
        }
        if (value instanceof Double) {
            return value.equals(Double.valueOf(express));
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(new BigDecimal(express)) == 0;
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() == Integer.parseInt(express);
        }
        return Boolean.FALSE;
    }

    public static Boolean isPattern(Object value, String regEx) {
        Pattern p;
        Matcher m;
        if (CheckUtil.isNull(value, null).booleanValue()) {
            return Boolean.FALSE;
        }
        if (value instanceof String && (m = (p = Pattern.compile(regEx)).matcher((String)value)).matches()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isTimeMillSeconds(Object value, String regEx) {
        Boolean number = CheckUtil.isNumber(value, regEx);
        if (number.booleanValue()) {
            return String.valueOf(value).length() == 13;
        }
        return false;
    }

    public static Boolean isCitizenId(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.CITIZEN_ID.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isCurrency(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.CURRENCY.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isCreditCode(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.CREDIT_CODE.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isChinesePostCode(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.ZIP_CODE.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isIpv4(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.IPV4.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isIpv6(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.IPV6.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isMac(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.MAC_ADDRESS.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isPlateNumber(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.PLATE_NUMBER.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isUrl(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        try {
            new URL(String.valueOf(value));
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static Boolean isISBN(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.ISBN_REGEX.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isBankNumber(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        String number = String.valueOf(value);
        if (number.length() != 16 && number.length() != 19) {
            return false;
        }
        if (!number.matches("\\d+")) {
            return false;
        }
        char[] digits = number.toCharArray();
        int len = number.length();
        int numSum = 0;
        int i = len - 1;
        int j = 1;
        while (i >= 0) {
            int value0 = digits[i] - 48;
            if (j % 2 == 0 && (value0 *= 2) > 9) {
                value0 -= 9;
            }
            numSum += value0;
            --i;
            ++j;
        }
        return numSum % 10 == 0;
    }

    public static Boolean isUUID(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.UUID.matcher(String.valueOf(value)).matches() || RegexPattern.UUID_SIMPLE.matcher(String.valueOf(value)).matches();
    }
}

