/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.store.util;

import cn.wizzer.iot.mqtt.server.common.session.SessionStore;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.util.Base64;
import org.nutz.lang.util.NutMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreUtil.class);

    public static NutMap transPublishToMapBeta(SessionStore store) {
        try {
            NutMap sessionStore = new NutMap();
            sessionStore.put((Object)"clientId", (Object)store.getClientId());
            sessionStore.put((Object)"channelId", (Object)store.getChannelId());
            sessionStore.put((Object)"cleanSession", (Object)store.isCleanSession());
            sessionStore.put((Object)"brokerId", (Object)store.getBrokerId());
            sessionStore.put((Object)"expire", (Object)store.getExpire());
            MqttPublishMessage msg = store.getWillMessage();
            if (null != msg) {
                sessionStore.addv("payload", (Object)Base64.getEncoder().encodeToString(msg.payload().array()));
                sessionStore.addv("messageType", (Object)msg.fixedHeader().messageType().value());
                sessionStore.addv("isDup", (Object)msg.fixedHeader().isDup());
                sessionStore.addv("qosLevel", (Object)msg.fixedHeader().qosLevel().value());
                sessionStore.addv("isRetain", (Object)msg.fixedHeader().isRetain());
                sessionStore.addv("remainingLength", (Object)msg.fixedHeader().remainingLength());
                sessionStore.addv("topicName", (Object)msg.variableHeader().topicName());
                sessionStore.addv("packetId", (Object)msg.variableHeader().packetId());
                sessionStore.addv("hasWillMessage", (Object)true);
            }
            return sessionStore;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static SessionStore mapTransToPublishMsgBeta(NutMap store) {
        SessionStore sessionStore = new SessionStore();
        if (store.getBoolean("hasWillMessage", false)) {
            byte[] payloads = Base64.getDecoder().decode(store.getString("payload"));
            ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(payloads.length);
            buf.writeBytes(payloads);
            MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.valueOf((int)store.getInt("messageType")), store.getBoolean("isDup"), MqttQoS.valueOf((int)store.getInt("qosLevel")), store.getBoolean("isRetain"), store.getInt("remainingLength"));
            MqttPublishVariableHeader mqttPublishVariableHeader = new MqttPublishVariableHeader(store.getString("topicName"), store.getInt("packetId"));
            MqttPublishMessage mqttPublishMessage = new MqttPublishMessage(mqttFixedHeader, mqttPublishVariableHeader, buf);
            sessionStore.setWillMessage(mqttPublishMessage);
        }
        sessionStore.setChannelId(store.getString("channelId"));
        sessionStore.setClientId(store.getString("clientId"));
        sessionStore.setCleanSession(store.getBoolean("cleanSession"));
        sessionStore.setBrokerId(store.getString("brokerId"));
        sessionStore.setExpire(store.getInt("expire"));
        return sessionStore;
    }
}

