/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.store.subscribe;

import cn.hutool.core.util.StrUtil;
import cn.wizzer.iot.mqtt.server.common.subscribe.ISubscribeStoreService;
import cn.wizzer.iot.mqtt.server.common.subscribe.SubscribeStore;
import cn.wizzer.iot.mqtt.server.store.cache.SubscribeNotWildcardCache;
import cn.wizzer.iot.mqtt.server.store.cache.SubscribeWildcardCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;

@IocBean
public class SubscribeStoreService
implements ISubscribeStoreService {
    @Inject
    private SubscribeNotWildcardCache subscribeNotWildcardCache;
    @Inject
    private SubscribeWildcardCache subscribeWildcardCache;

    public void put(String topicFilter, SubscribeStore subscribeStore) {
        if (StrUtil.contains((CharSequence)topicFilter, (char)'#') || StrUtil.contains((CharSequence)topicFilter, (char)'+')) {
            this.subscribeWildcardCache.put(topicFilter, subscribeStore.getClientId(), subscribeStore);
        } else {
            this.subscribeNotWildcardCache.put(topicFilter, subscribeStore.getClientId(), subscribeStore);
        }
    }

    public void remove(String topicFilter, String clientId) {
        if (StrUtil.contains((CharSequence)topicFilter, (char)'#') || StrUtil.contains((CharSequence)topicFilter, (char)'+')) {
            this.subscribeWildcardCache.remove(topicFilter, clientId);
        } else {
            this.subscribeNotWildcardCache.remove(topicFilter, clientId);
        }
    }

    public void removeForClient(String clientId) {
        this.subscribeNotWildcardCache.removeForClient(clientId);
        this.subscribeWildcardCache.removeForClient(clientId);
    }

    public List<SubscribeStore> search(String topic) {
        ArrayList<SubscribeStore> subscribeStores = new ArrayList<SubscribeStore>();
        List<SubscribeStore> list = this.subscribeNotWildcardCache.all(topic);
        if (list.size() > 0) {
            subscribeStores.addAll(list);
        }
        this.subscribeWildcardCache.all().forEach((topicFilter, map) -> {
            if (StrUtil.split((CharSequence)topic, (char)'/').size() >= StrUtil.split((CharSequence)topicFilter, (char)'/').size()) {
                List splitTopics = StrUtil.split((CharSequence)topic, (char)'/');
                List spliteTopicFilters = StrUtil.split((CharSequence)topicFilter, (char)'/');
                String newTopicFilter = "";
                for (int i = 0; i < spliteTopicFilters.size(); ++i) {
                    String value = (String)spliteTopicFilters.get(i);
                    if (value.equals("+")) {
                        newTopicFilter = newTopicFilter + "+/";
                        continue;
                    }
                    if (value.equals("#")) {
                        newTopicFilter = newTopicFilter + "#/";
                        break;
                    }
                    newTopicFilter = newTopicFilter + (String)splitTopics.get(i) + "/";
                }
                if (topicFilter.equals(newTopicFilter = StrUtil.removeSuffix((CharSequence)newTopicFilter, (CharSequence)"/"))) {
                    Collection collection = map.values();
                    ArrayList list2 = new ArrayList(collection);
                    subscribeStores.addAll(list2);
                }
            }
        });
        return subscribeStores;
    }
}

