/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.store.message;

import cn.wizzer.iot.mqtt.server.common.message.IMessageIdService;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IocBean(create="init")
public class MessageIdService
implements IMessageIdService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageIdService.class);
    @Inject
    private RedisService redisService;

    public int getNextMessageId() {
        try {
            int nextMsgId;
            while ((nextMsgId = (int)(this.redisService.incr("mqttwk:messageid:num") % 65536L)) <= 0) {
            }
            return nextMsgId;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public void init() {
        this.redisService.del("mqttwk:messageid:num");
    }
}

