/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.store.message;

import cn.wizzer.iot.mqtt.server.common.message.DupPubRelMessageStore;
import cn.wizzer.iot.mqtt.server.common.message.IDupPubRelMessageStoreService;
import cn.wizzer.iot.mqtt.server.common.message.IMessageIdService;
import cn.wizzer.iot.mqtt.server.store.cache.DupPubRelMessageCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;

@IocBean
public class DupPubRelMessageStoreService
implements IDupPubRelMessageStoreService {
    @Inject
    private IMessageIdService messageIdService;
    @Inject
    private DupPubRelMessageCache dupPubRelMessageCache;

    public void put(String clientId, DupPubRelMessageStore dupPubRelMessageStore) {
        this.dupPubRelMessageCache.put(clientId, dupPubRelMessageStore.getMessageId(), dupPubRelMessageStore);
    }

    public List<DupPubRelMessageStore> get(String clientId) {
        if (this.dupPubRelMessageCache.containsKey(clientId)) {
            ConcurrentHashMap<Integer, DupPubRelMessageStore> map = this.dupPubRelMessageCache.get(clientId);
            Collection<DupPubRelMessageStore> collection = map.values();
            return new ArrayList<DupPubRelMessageStore>(collection);
        }
        return new ArrayList<DupPubRelMessageStore>();
    }

    public void remove(String clientId, int messageId) {
        this.dupPubRelMessageCache.remove(clientId, messageId);
    }

    public void removeByClient(String clientId) {
        if (this.dupPubRelMessageCache.containsKey(clientId)) {
            this.dupPubRelMessageCache.remove(clientId);
        }
    }
}

