/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.store.message;

import cn.wizzer.iot.mqtt.server.common.message.DupPublishMessageStore;
import cn.wizzer.iot.mqtt.server.common.message.IDupPublishMessageStoreService;
import cn.wizzer.iot.mqtt.server.common.message.IMessageIdService;
import cn.wizzer.iot.mqtt.server.store.cache.DupPublishMessageCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;

@IocBean
public class DupPublishMessageStoreService
implements IDupPublishMessageStoreService {
    @Inject
    private IMessageIdService messageIdService;
    @Inject
    private DupPublishMessageCache dupPublishMessageCache;

    public void put(String clientId, DupPublishMessageStore dupPublishMessageStore) {
        this.dupPublishMessageCache.put(clientId, dupPublishMessageStore.getMessageId(), dupPublishMessageStore);
    }

    public List<DupPublishMessageStore> get(String clientId) {
        if (this.dupPublishMessageCache.containsKey(clientId)) {
            ConcurrentHashMap<Integer, DupPublishMessageStore> map = this.dupPublishMessageCache.get(clientId);
            Collection<DupPublishMessageStore> collection = map.values();
            return new ArrayList<DupPublishMessageStore>(collection);
        }
        return new ArrayList<DupPublishMessageStore>();
    }

    public void remove(String clientId, int messageId) {
        this.dupPublishMessageCache.remove(clientId, messageId);
    }

    public void removeByClient(String clientId) {
        this.dupPublishMessageCache.remove(clientId);
    }
}

