/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.store.cache;

import cn.wizzer.iot.mqtt.server.common.subscribe.SubscribeStore;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.nutz.aop.interceptor.async.Async;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;

@IocBean
public class SubscribeNotWildcardCache {
    private static final String CACHE_PRE = "mqttwk:subnotwildcard:";
    private static final String CACHE_CLIENT_PRE = "mqttwk:client:";
    @Inject
    private RedisService redisService;

    public SubscribeStore put(String topic, String clientId, SubscribeStore subscribeStore) {
        this.redisService.hset(CACHE_PRE + topic, clientId, JSONObject.toJSONString((Object)subscribeStore));
        this.redisService.sadd(CACHE_CLIENT_PRE + clientId, new String[]{topic});
        return subscribeStore;
    }

    public SubscribeStore get(String topic, String clientId) {
        return (SubscribeStore)JSONObject.parseObject((String)this.redisService.hget(CACHE_PRE + topic, clientId), SubscribeStore.class);
    }

    public boolean containsKey(String topic, String clientId) {
        return this.redisService.hexists(CACHE_PRE + topic, clientId);
    }

    @Async
    public void remove(String topic, String clientId) {
        this.redisService.srem(CACHE_CLIENT_PRE + clientId, new String[]{topic});
        this.redisService.hdel(CACHE_PRE + topic, new String[]{clientId});
    }

    @Async
    public void removeForClient(String clientId) {
        for (String topic : this.redisService.smembers(CACHE_CLIENT_PRE + clientId)) {
            this.redisService.hdel(CACHE_PRE + topic, new String[]{clientId});
        }
        this.redisService.del(CACHE_CLIENT_PRE + clientId);
    }

    public Map<String, ConcurrentHashMap<String, SubscribeStore>> all() {
        HashMap<String, ConcurrentHashMap<String, SubscribeStore>> map = new HashMap<String, ConcurrentHashMap<String, SubscribeStore>>();
        Set set = this.redisService.keys("mqttwk:subnotwildcard:*");
        if (set != null && !set.isEmpty()) {
            set.forEach(entry -> {
                ConcurrentHashMap map1 = new ConcurrentHashMap();
                Map map2 = this.redisService.hgetAll(entry);
                if (map2 != null && !map2.isEmpty()) {
                    map2.forEach((k, v) -> map1.put(k, JSONObject.parseObject((String)v, SubscribeStore.class)));
                    map.put(entry.substring(CACHE_PRE.length()), map1);
                }
            });
        }
        return map;
    }

    public List<SubscribeStore> all(String topic) {
        ArrayList<SubscribeStore> list = new ArrayList<SubscribeStore>();
        Map map = this.redisService.hgetAll(CACHE_PRE + topic);
        if (map != null && !map.isEmpty()) {
            map.forEach((k, v) -> list.add((SubscribeStore)JSONObject.parseObject((String)v, SubscribeStore.class)));
        }
        return list;
    }
}

