/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.store.cache;

import cn.wizzer.iot.mqtt.server.common.message.DupPublishMessageStore;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nutz.aop.interceptor.async.Async;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;

@IocBean
public class DupPublishMessageCache {
    private static final String CACHE_PRE = "mqttwk:publish:";
    @Inject
    private RedisService redisService;
    @Inject
    private PropertiesProxy conf;

    public DupPublishMessageStore put(String clientId, Integer messageId, DupPublishMessageStore dupPublishMessageStore) {
        this.redisService.hset(CACHE_PRE + clientId, String.valueOf(messageId), JSONObject.toJSONString((Object)dupPublishMessageStore));
        return dupPublishMessageStore;
    }

    public ConcurrentHashMap<Integer, DupPublishMessageStore> get(String clientId) {
        ConcurrentHashMap<Integer, DupPublishMessageStore> map = new ConcurrentHashMap<Integer, DupPublishMessageStore>();
        Map map1 = this.redisService.hgetAll(CACHE_PRE + clientId);
        if (map1 != null && !map1.isEmpty()) {
            map1.forEach((k, v) -> map.put(Integer.valueOf(k), (DupPublishMessageStore)JSONObject.parseObject((String)v, DupPublishMessageStore.class)));
        }
        return map;
    }

    public boolean containsKey(String clientId) {
        return this.redisService.exists(CACHE_PRE + clientId);
    }

    @Async
    public void remove(String clientId, Integer messageId) {
        this.redisService.hdel(CACHE_PRE + clientId, new String[]{String.valueOf(messageId)});
    }

    @Async
    public void remove(String clientId) {
        this.redisService.del(CACHE_PRE + clientId);
    }
}

