/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.base.Globals;
import cn.wizzer.app.web.commons.ext.wx.WxService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.DateUtil;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.models.Wx_reply_img;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxReplyImgService;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.boot.starter.ftp.FtpService;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.POST;
import org.nutz.mvc.annotation.Param;
import org.nutz.mvc.impl.AdaptorErrorContext;
import org.nutz.mvc.upload.TempFile;
import org.nutz.mvc.upload.UploadAdaptor;
import org.nutz.weixin.spi.WxApi2;
import org.nutz.weixin.spi.WxResp;

@IocBean
@At(value={"/platform/wx/reply/img"})
public class WxReplyImgController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private WxReplyImgService wxReplyImgService;
    @Inject
    @Reference
    private WxConfigService wxConfigService;
    @Inject
    private WxService wxService;
    @Inject
    private FtpService ftpService;

    @At(value={"/", "/index/?"})
    @Ok(value="beetl:/platform/wx/reply/img/index.html")
    @RequiresPermissions(value={"wx.reply"})
    public void index(String wxid, HttpServletRequest req) {
        Wx_config wxConfig = null;
        List list = this.wxConfigService.query((Condition)Cnd.NEW());
        if (list.size() > 0 && Strings.isBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)list.get(0);
        }
        if (Strings.isNotBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)this.wxConfigService.fetch(wxid);
        }
        req.setAttribute("wxConfig", wxConfig);
        req.setAttribute("wxList", (Object)list);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.img.add"})
    @SLog(tag="\u6dfb\u52a0\u56de\u590d\u56fe\u7247", msg="\u56fe\u7247\u8def\u5f84:${args[0].picurl}")
    public Object addDo(@Param(value="..") Wx_reply_img img, HttpServletRequest req) {
        try {
            img.setOpBy(StringUtil.getPlatformUid());
            this.wxReplyImgService.insert((Object)img);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply"})
    public Object edit(String id) {
        try {
            return Result.success().addData(this.wxReplyImgService.fetch(id));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.img.edit"})
    @SLog(tag="\u4fee\u6539\u56de\u590d\u56fe\u7247", msg="\u56fe\u7247\u8def\u5f84:${args[0].picurl}")
    public Object editDo(@Param(value="..") Wx_reply_img img, HttpServletRequest req) {
        try {
            this.wxReplyImgService.updateIgnoreNull((Object)img);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.img.delete"})
    @SLog(tag="\u5220\u9664\u56de\u590d\u56fe\u7247", msg="\u56fe\u7247\u8def\u5f84:${args[1].getAttribute('picurl')}}")
    public Object delete(String id, HttpServletRequest req) {
        try {
            req.setAttribute("picurl", (Object)((Wx_reply_img)this.wxReplyImgService.fetch(id)).getPicurl());
            this.wxReplyImgService.delete(id);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.img.delete"})
    @SLog(tag="\u5220\u9664\u56de\u590d\u56fe\u7247", msg="ID:${args[0]}")
    public Object deletes(@Param(value="ids") String ids, HttpServletRequest req) {
        try {
            this.wxReplyImgService.delete(StringUtils.split((String)ids, (String)","));
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.reply"})
    public Object data(@Param(value="wxid") String wxid, @Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        Cnd cnd = Cnd.NEW();
        if (Strings.isNotBlank((CharSequence)wxid)) {
            cnd.and("wxid", "=", (Object)wxid);
        }
        if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
            cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
        }
        return Result.success().addData((Object)this.wxReplyImgService.listPage(Integer.valueOf(pageNumber), pageSize, (Condition)cnd));
    }

    @AdaptBy(type=UploadAdaptor.class, args={"ioc:imageUpload"})
    @POST
    @At(value={"/uploadImage/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply"})
    public Object uploadImage(String wxid, @Param(value="Filedata") TempFile tf, HttpServletRequest req, AdaptorErrorContext err) {
        try {
            if (err != null && err.getAdaptorErr() != null) {
                return NutMap.NEW().addv("code", (Object)1).addv("msg", (Object)"\u6587\u4ef6\u4e0d\u5408\u6cd5");
            }
            if (tf == null) {
                return Result.error((String)"\u7a7a\u6587\u4ef6");
            }
            WxApi2 wxApi2 = this.wxService.getWxApi2(wxid);
            WxResp resp = wxApi2.add_material("image", tf.getFile());
            if (resp.errcode() != 0) {
                return Result.error((String)resp.errmsg());
            }
            String suffixName = tf.getSubmittedFileName().substring(tf.getSubmittedFileName().lastIndexOf(".")).toLowerCase();
            String filePath = Globals.AppUploadBase + "/image/" + DateUtil.format(new Date(), "yyyyMMdd") + "/";
            String fileName = R.UU32() + suffixName;
            String url = filePath + fileName;
            if (this.ftpService.upload(filePath, fileName, tf.getInputStream())) {
                return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)NutMap.NEW().addv("id", resp.get((Object)"media_id")).addv("picurl", (Object)url));
            }
            return Result.error((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5ftp\u7528\u6237\u662f\u5426\u6709\u521b\u5efa\u76ee\u5f55\u6743\u9650");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            return Result.error((String)"\u56fe\u7247\u683c\u5f0f\u9519\u8bef");
        }
    }
}

