/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.ext.wx.WxService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.models.Wx_msg_reply;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxMsgReplyService;
import cn.wizzer.app.wx.modules.services.WxMsgService;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;
import org.nutz.weixin.bean.WxOutMsg;
import org.nutz.weixin.spi.WxApi2;
import org.nutz.weixin.spi.WxResp;

@IocBean
@At(value={"/platform/wx/msg/user"})
public class WxMsgUserController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private WxMsgService wxMsgService;
    @Inject
    @Reference
    private WxConfigService wxConfigService;
    @Inject
    @Reference
    private WxMsgReplyService wxMsgReplyService;
    @Inject
    private WxService wxService;

    @At(value={"/", "/?"})
    @Ok(value="beetl:/platform/wx/msg/user/index.html")
    @RequiresPermissions(value={"wx.user.list"})
    public void index(String wxid, HttpServletRequest req) {
        Wx_config wxConfig = null;
        List list = this.wxConfigService.query((Condition)Cnd.NEW());
        if (list.size() > 0 && Strings.isBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)list.get(0);
        }
        if (Strings.isNotBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)this.wxConfigService.fetch(wxid);
        }
        req.setAttribute("wxConfig", wxConfig);
        req.setAttribute("wxList", (Object)list);
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.user.list"})
    public Object data(@Param(value="wxid") String wxid, @Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)wxid)) {
            cnd.and("wxid", "=", (Object)wxid);
        }
        if (Strings.isNotBlank((CharSequence)searchName) && Strings.isNotBlank((CharSequence)searchKeyword)) {
            cnd.and(searchName, "like", (Object)("%" + searchKeyword + "%"));
        }
        if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
            cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
        }
        return Result.success().addData((Object)this.wxMsgService.listPageLinks(Integer.valueOf(pageNumber), pageSize, (Condition)cnd, "reply"));
    }

    @At(value={"/replyDo/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.user.list.sync"})
    @SLog(tag="\u56de\u590d\u5fae\u4fe1", msg="\u5fae\u4fe1\u6635\u79f0:${args[2]}")
    public Object replyDo(String wxid, @Param(value="msgid") String msgid, @Param(value="nickname") String nickname, @Param(value="openid") String openid, @Param(value="replyContent") String content, HttpServletRequest req) {
        try {
            Wx_config config = (Wx_config)this.wxConfigService.fetch(wxid);
            WxApi2 wxApi2 = this.wxService.getWxApi2(wxid);
            long now = System.currentTimeMillis() / 1000L;
            WxOutMsg msg = new WxOutMsg();
            msg.setCreateTime(now);
            msg.setFromUserName(config.getAppid());
            msg.setMsgType("text");
            msg.setToUserName(openid);
            msg.setContent(content);
            WxResp wxResp = wxApi2.send(msg);
            if (wxResp.errcode() != 0) {
                return Result.error((String)wxResp.errmsg());
            }
            Wx_msg_reply reply = new Wx_msg_reply();
            reply.setContent(content);
            reply.setType("text");
            reply.setMsgid(msgid);
            reply.setOpenid(openid);
            reply.setWxid(wxid);
            Wx_msg_reply reply1 = (Wx_msg_reply)this.wxMsgReplyService.insert((Object)reply);
            if (reply1 != null) {
                this.wxMsgService.update(Chain.make((String)"replyId", (Object)reply1.getId()), (Condition)Cnd.where((String)"id", (String)"=", (Object)msgid));
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

