/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.slog;

import cn.wizzer.app.web.commons.slog.SLogService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.nutz.aop.InterceptorChain;
import org.nutz.aop.MethodInterceptor;
import org.nutz.el.El;
import org.nutz.ioc.Ioc;
import org.nutz.lang.segment.CharSegment;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class SLogAopInterceptor
implements MethodInterceptor {
    private static final Log log = Logs.get();
    protected SLogService sLogService;
    protected String source;
    protected String type;
    protected String tag;
    protected CharSegment seg;
    protected boolean param;
    protected boolean result;
    protected boolean async;
    protected Map<String, El> els;
    protected Ioc ioc;

    public SLogAopInterceptor(Ioc ioc, SLog slog, Method method) {
        this.seg = new CharSegment(slog.msg());
        if (this.seg.hasKey()) {
            this.els = new HashMap<String, El>();
            for (String key : this.seg.keys()) {
                this.els.put(key, new El((CharSequence)key));
            }
        }
        this.param = slog.param();
        this.result = slog.result();
        this.ioc = ioc;
        this.source = method.getDeclaringClass().getName() + "#" + method.getName();
        this.tag = slog.tag();
        SLog _s = method.getDeclaringClass().getAnnotation(SLog.class);
        if (_s != null) {
            this.tag = _s.tag() + "," + this.tag;
        }
        this.type = slog.type();
        this.async = slog.async();
    }

    public void filter(InterceptorChain chain) throws Throwable {
        try {
            chain.doChain();
            this.doLog("aop.after", this.seg, chain, null);
        }
        catch (Throwable e) {
            this.doLog("aop.error", this.seg, chain, e);
            throw e;
        }
    }

    protected void doLog(String t, CharSegment seg, InterceptorChain chain, Throwable e) {
        if (this.sLogService == null) {
            this.sLogService = (SLogService)this.ioc.get(SLogService.class);
        }
        try {
            this.sLogService.log(t, this.type, this.tag, this.source, seg, this.els, this.param, this.result, this.async, chain.getArgs(), chain.getReturn(), chain.getCallingMethod(), chain.getCallingObj(), e);
        }
        catch (Exception e1) {
            log.debug((Object)"slog fail", (Throwable)e1);
        }
    }
}

