/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_dict;
import cn.wizzer.app.sys.modules.services.SysDictService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/dict"})
public class SysDictController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysDictService dictService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/dict/index.html")
    @RequiresPermissions(value={"sys.manager.dict"})
    public Object index() {
        return this.dictService.query((Condition)Cnd.where((String)"parentId", (String)"=", (Object)"").or("parentId", "is", null).asc("location").asc("path"));
    }

    @At
    @Ok(value="beetl:/platform/sys/dict/add.html")
    @RequiresPermissions(value={"sys.manager.dict"})
    public Object add(@Param(value="pid") String pid) {
        return Strings.isBlank((CharSequence)pid) ? null : this.dictService.fetch(pid);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.dict.add"})
    @SLog(tag="\u65b0\u5efa\u5b57\u5178", msg="\u5b57\u5178\u540d\u79f0:${args[0].name}")
    public Object addDo(@Param(value="..") Sys_dict dict, @Param(value="parentId") String parentId, HttpServletRequest req) {
        try {
            dict.setOpBy(StringUtil.getPlatformUid());
            this.dictService.save(dict, parentId);
            this.dictService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/child/?"})
    @Ok(value="beetl:/platform/sys/dict/child.html")
    @RequiresPermissions(value={"sys.manager.dict"})
    public Object child(String id) {
        return this.dictService.query((Condition)Cnd.where((String)"parentId", (String)"=", (Object)id).asc("location").asc("path"));
    }

    @At(value={"/edit/?"})
    @Ok(value="beetl:/platform/sys/dict/edit.html")
    @RequiresPermissions(value={"sys.manager.dict"})
    public Object edit(String id, HttpServletRequest req) {
        Sys_dict dict = (Sys_dict)this.dictService.fetch(id);
        if (dict != null) {
            req.setAttribute("parentUnit", this.dictService.fetch(dict.getParentId()));
        }
        return dict;
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.dict.edit"})
    @SLog(tag="\u7f16\u8f91\u5b57\u5178", msg="\u5b57\u5178\u540d\u79f0:${args[0].name}")
    public Object editDo(@Param(value="..") Sys_dict dict, @Param(value="parentId") String parentId, HttpServletRequest req) {
        try {
            dict.setOpBy(StringUtil.getPlatformUid());
            dict.setOpAt(Long.valueOf(Times.getTS()));
            this.dictService.updateIgnoreNull((Object)dict);
            this.dictService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.dict.delete"})
    @SLog(tag="\u5220\u9664\u5b57\u5178", msg="\u5b57\u5178\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object delete(String id, HttpServletRequest req) {
        try {
            Sys_dict dict = (Sys_dict)this.dictService.fetch(id);
            req.setAttribute("name", (Object)dict.getName());
            this.dictService.deleteAndChild(dict);
            this.dictService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.dict"})
    public Object tree(@Param(value="pid") String pid) {
        List list = this.dictService.query((Condition)Cnd.where((String)"parentId", (String)"=", (Object)Strings.sBlank((Object)pid)).asc("path"));
        ArrayList tree = new ArrayList();
        for (Sys_dict dict : list) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("id", dict.getId());
            obj.put("text", dict.getName());
            obj.put("children", dict.isHasChildren());
            tree.add(obj);
        }
        return tree;
    }

    @At
    @Ok(value="beetl:/platform/sys/dict/sort.html")
    @RequiresPermissions(value={"sys.manager.dict"})
    public void sort(HttpServletRequest req) {
        List list = this.dictService.query((Condition)Cnd.orderBy().asc("location").asc("path"));
        ArrayList<Sys_dict> firstMenus = new ArrayList<Sys_dict>();
        HashMap<String, ArrayList<Sys_dict>> secondMenus = new HashMap<String, ArrayList<Sys_dict>>();
        for (Sys_dict menu : list) {
            if (menu.getPath().length() > 4) {
                ArrayList<Sys_dict> s = (ArrayList<Sys_dict>)secondMenus.get(StringUtil.getParentId(menu.getPath()));
                if (s == null) {
                    s = new ArrayList<Sys_dict>();
                }
                s.add(menu);
                secondMenus.put(StringUtil.getParentId(menu.getPath()), s);
                continue;
            }
            if (menu.getPath().length() != 4) continue;
            firstMenus.add(menu);
        }
        req.setAttribute("firstMenus", firstMenus);
        req.setAttribute("secondMenus", secondMenus);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.dict.edit"})
    public Object sortDo(@Param(value="ids") String ids, HttpServletRequest req) {
        try {
            String[] menuIds = StringUtils.split((String)ids, (String)",");
            int i = 0;
            this.dictService.execute(Sqls.create((String)"update sys_dict set location=0"));
            for (String s : menuIds) {
                if (Strings.isBlank((CharSequence)s)) continue;
                this.dictService.update(Chain.make((String)"location", (Object)i), (Condition)Cnd.where((String)"id", (String)"=", (Object)s));
                ++i;
            }
            this.dictService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }
}

