/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.ext.wx.WxService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.models.Wx_tpl_list;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxTplListService;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.datatable.DataTableColumn;
import cn.wizzer.framework.page.datatable.DataTableOrder;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;
import org.nutz.weixin.spi.WxApi2;
import org.nutz.weixin.spi.WxResp;

@IocBean
@At(value={"/platform/wx/tpl/list"})
public class WxTplListController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private WxTplListService wxTplListService;
    @Inject
    @Reference
    private WxConfigService wxConfigService;
    @Inject
    private WxService wxService;

    @At(value={"", "/index/?"})
    @Ok(value="beetl:/platform/wx/tpl/list/index.html")
    @RequiresPermissions(value={"wx.tpl.list"})
    public void index(String wxid, HttpServletRequest req) {
        List list = this.wxConfigService.query((Condition)Cnd.NEW());
        if (list.size() > 0 && Strings.isBlank((CharSequence)wxid)) {
            wxid = ((Wx_config)list.get(0)).getId();
        }
        req.setAttribute("wxList", (Object)list);
        req.setAttribute("wxid", (Object)Strings.sBlank((Object)wxid));
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.tpl.list"})
    public Object data(@Param(value="wxid") String wxid, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)wxid)) {
            cnd.and("wxid", "=", (Object)wxid);
        }
        return this.wxTplListService.data(length, start, draw, order, columns, cnd, null);
    }

    @At
    @Ok(value="json")
    @SLog(tag="\u83b7\u53d6\u6a21\u677f\u5217\u8868", msg="")
    @RequiresPermissions(value={"wx.tpl.list.get"})
    public Object getDo(@Param(value="wxid") String wxid, HttpServletRequest req) {
        try {
            WxApi2 wxApi2 = this.wxService.getWxApi2(wxid);
            WxResp wxResp = wxApi2.get_all_private_template();
            List lists = wxResp.getList("template_list", Wx_tpl_list.class);
            for (Wx_tpl_list o : lists) {
                o.setWxid(wxid);
                this.wxTplListService.insert((Object)o);
            }
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }
}

