/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_menu;
import cn.wizzer.app.sys.modules.models.Sys_unit;
import cn.wizzer.app.sys.modules.models.Sys_user;
import cn.wizzer.app.sys.modules.services.SysMenuService;
import cn.wizzer.app.sys.modules.services.SysUnitService;
import cn.wizzer.app.sys.modules.services.SysUserService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.ShiroUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import cn.wizzer.framework.page.datatable.DataTableColumn;
import cn.wizzer.framework.page.datatable.DataTableOrder;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ByteSource;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.random.R;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/user"})
public class SysUserController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private SysUserService sysUserService;
    @Inject
    @Reference
    private SysMenuService sysMenuService;
    @Inject
    @Reference
    private SysUnitService sysUnitService;
    @Inject
    private ShiroUtil shiroUtil;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/user/index.html")
    @RequiresPermissions(value={"sys.manager.user"})
    public void index() {
    }

    @At
    @Ok(value="beetl:/platform/sys/user/add.html")
    @RequiresPermissions(value={"sys.manager.user"})
    public Object add(@Param(value="unitid") String unitid) {
        return Strings.isBlank((CharSequence)unitid) ? null : this.sysUnitService.fetch(unitid);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user.add"})
    @SLog(tag="\u65b0\u5efa\u7528\u6237", msg="\u7528\u6237\u540d:${args[0].loginname}")
    public Object addDo(@Param(value="..") Sys_user user, HttpServletRequest req) {
        try {
            String salt = R.UU32();
            user.setSalt(salt);
            user.setPassword(new Sha256Hash((Object)user.getPassword(), (Object)ByteSource.Util.bytes((String)salt), 1024).toHex());
            user.setLoginPjax(true);
            user.setLoginCount(Integer.valueOf(0));
            user.setLoginAt(Long.valueOf(0L));
            user.setOpBy(StringUtil.getPlatformUid());
            user.setOpAt(Long.valueOf(Times.getTS()));
            this.sysUserService.insert((Object)user);
            this.sysUserService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="beetl:/platform/sys/user/edit.html")
    @RequiresPermissions(value={"sys.manager.user"})
    public Object edit(String id) {
        return this.sysUserService.fetchLinks(this.sysUserService.fetch(id), "unit");
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user.edit"})
    @SLog(tag="\u4fee\u6539\u7528\u6237", msg="\u7528\u6237\u540d:${args[1]}->${args[0].loginname}")
    public Object editDo(@Param(value="..") Sys_user user, @Param(value="oldLoginname") String oldLoginname, HttpServletRequest req) {
        try {
            Sys_user u;
            if (!Strings.sBlank((Object)oldLoginname).equals(user.getLoginname()) && (u = (Sys_user)this.sysUserService.fetch((Condition)Cnd.where((String)"loginname", (String)"=", (Object)user.getLoginname()))) != null) {
                return Result.error((String)"\u7528\u6237\u540d\u5df2\u5b58\u5728");
            }
            user.setOpBy(StringUtil.getPlatformUid());
            user.setOpAt(Long.valueOf(Times.getTS()));
            this.sysUserService.updateIgnoreNull((Object)user);
            this.sysUserService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/resetPwd/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user.edit"})
    @SLog(tag="\u91cd\u7f6e\u5bc6\u7801", msg="\u7528\u6237\u540d:${args[1].getAttribute('loginname')}")
    public Object resetPwd(String id, HttpServletRequest req) {
        try {
            Sys_user user = (Sys_user)this.sysUserService.fetch(id);
            String salt = R.UU32();
            String pwd = R.captchaNumber((int)6);
            String hashedPasswordBase64 = new Sha256Hash((Object)pwd, (Object)ByteSource.Util.bytes((String)salt), 1024).toHex();
            this.sysUserService.update(Chain.make((String)"salt", (Object)salt).add("password", (Object)hashedPasswordBase64), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            this.sysUserService.clearCache();
            req.setAttribute("loginname", (Object)user.getLoginname());
            return Result.success((String)"system.success", (Object)pwd);
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user.delete"})
    @SLog(tag="\u5220\u9664\u7528\u6237", msg="\u7528\u6237\u540d:${args[1].getAttribute('loginname')}")
    public Object delete(String userId, HttpServletRequest req) {
        try {
            Sys_user user = (Sys_user)this.sysUserService.fetch(userId);
            if ("superadmin".equals(user.getLoginname())) {
                return Result.error((String)"system.not.allow");
            }
            this.sysUserService.deleteById(userId);
            this.sysUserService.clearCache();
            req.setAttribute("loginname", (Object)user.getLoginname());
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user.delete"})
    @SLog(tag="\u6279\u91cf\u5220\u9664\u7528\u6237", msg="\u7528\u6237ID:${args[1].getAttribute('ids')}")
    public Object deletes(@Param(value="ids") String[] userIds, HttpServletRequest req) {
        try {
            Sys_user user = (Sys_user)this.sysUserService.fetch((Condition)Cnd.where((String)"loginname", (String)"=", (Object)"superadmin"));
            StringBuilder sb = new StringBuilder();
            for (String s : userIds) {
                if (s.equals(user.getId())) {
                    return Result.error((String)"system.not.allow");
                }
                sb.append(s).append(",");
            }
            this.sysUserService.deleteByIds(userIds);
            this.sysUserService.clearCache();
            req.setAttribute("ids", (Object)sb.toString());
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user.edit"})
    @SLog(tag="\u542f\u7528\u7528\u6237", msg="\u7528\u6237\u540d:${args[1].getAttribute('loginname')}")
    public Object enable(String userId, HttpServletRequest req) {
        try {
            req.setAttribute("loginname", (Object)((Sys_user)this.sysUserService.fetch(userId)).getLoginname());
            this.sysUserService.update(Chain.make((String)"disabled", (Object)false), (Condition)Cnd.where((String)"id", (String)"=", (Object)userId));
            this.sysUserService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user.edit"})
    @SLog(tag="\u7981\u7528\u7528\u6237", msg="\u7528\u6237\u540d:${args[1].getAttribute('loginname')}")
    public Object disable(String userId, HttpServletRequest req) {
        try {
            String loginname = ((Sys_user)this.sysUserService.fetch(userId)).getLoginname();
            if ("superadmin".equals(loginname)) {
                return Result.error((String)"system.not.allow");
            }
            req.setAttribute("loginname", (Object)loginname);
            this.sysUserService.update(Chain.make((String)"disabled", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)userId));
            this.sysUserService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/detail/?"})
    @Ok(value="beetl:/platform/sys/user/detail.html")
    @RequiresPermissions(value={"sys.manager.user"})
    public Object detail(String id) {
        if (!Strings.isBlank((CharSequence)id)) {
            Sys_user user = (Sys_user)this.sysUserService.fetch(id);
            return this.sysUserService.fetchLinks((Object)user, "roles");
        }
        return null;
    }

    @At(value={"/menu/?"})
    @Ok(value="beetl:/platform/sys/user/menu.html")
    @RequiresPermissions(value={"sys.manager.user"})
    public Object menu(String id, HttpServletRequest req) {
        Sys_user user = (Sys_user)this.sysUserService.fetch(id);
        List menus = this.sysUserService.getMenusAndButtons(id);
        List datas = this.sysUserService.getDatas(id);
        ArrayList<Sys_menu> firstMenus = new ArrayList<Sys_menu>();
        ArrayList<Sys_menu> secondMenus = new ArrayList<Sys_menu>();
        for (Sys_menu menu : menus) {
            for (Sys_menu bt : datas) {
                if (!menu.getPath().equals(bt.getPath().substring(0, bt.getPath().length() - 4))) continue;
                menu.setHasChildren(true);
                break;
            }
            if (menu.getPath().length() == 4) {
                firstMenus.add(menu);
                continue;
            }
            secondMenus.add(menu);
        }
        req.setAttribute("userFirstMenus", firstMenus);
        req.setAttribute("userSecondMenus", secondMenus);
        req.setAttribute("jsonSecondMenus", (Object)Json.toJson(secondMenus));
        return user;
    }

    @At
    @Ok(value="json:{locked:'password|salt',ignoreNull:false}")
    @RequiresPermissions(value={"sys.manager.user"})
    public Object data(@Param(value="unitid") String unitid, @Param(value="loginname") String loginname, @Param(value="username") String username, @Param(value="length") int length, @Param(value="start") int start, @Param(value="draw") int draw, @Param(value="::order") List<DataTableOrder> order, @Param(value="::columns") List<DataTableColumn> columns) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)unitid) && !"root".equals(unitid)) {
            cnd.and("unitid", "=", (Object)unitid);
        }
        if (!Strings.isBlank((CharSequence)loginname)) {
            cnd.and("loginname", "like", (Object)("%" + loginname + "%"));
        }
        if (!Strings.isBlank((CharSequence)username)) {
            cnd.and("username", "like", (Object)("%" + username + "%"));
        }
        return this.sysUserService.data(length, start, draw, order, columns, cnd, null);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.user"})
    public Object tree(@Param(value="pid") String pid) {
        List list = new ArrayList();
        ArrayList tree = new ArrayList();
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (this.shiroUtil.hasRole("sysadmin")) {
            Cnd cnd = Cnd.NEW();
            if (Strings.isBlank((CharSequence)pid)) {
                cnd.and("parentId", "=", (Object)"").or("parentId", "is", null);
            } else {
                cnd.and("parentId", "=", (Object)pid);
            }
            cnd.asc("path");
            list = this.sysUnitService.query((Condition)cnd);
            if (Strings.isBlank((CharSequence)pid)) {
                obj.put("id", "root");
                obj.put("text", "\u6240\u6709\u7528\u6237");
                obj.put("children", false);
                tree.add(obj);
            }
        } else {
            Sys_user user = (Sys_user)this.shiroUtil.getPrincipal();
            if (user != null && Strings.isBlank((CharSequence)pid)) {
                list = this.sysUnitService.query((Condition)Cnd.where((String)"id", (String)"=", (Object)user.getUnitid()).asc("path"));
            } else {
                Cnd cnd = Cnd.NEW();
                if (Strings.isBlank((CharSequence)pid)) {
                    cnd.and("parentId", "=", (Object)"").or("parentId", "is", null);
                } else {
                    cnd.and("parentId", "=", (Object)pid);
                }
                cnd.asc("path");
                list = this.sysUnitService.query((Condition)cnd);
            }
        }
        for (Sys_unit unit : list) {
            obj = new HashMap();
            obj.put("id", unit.getId());
            obj.put("text", unit.getName());
            obj.put("children", unit.isHasChildren());
            tree.add(obj);
        }
        return tree;
    }

    @At
    @Ok(value="beetl:/platform/sys/user/pass.html")
    @RequiresAuthentication
    public void pass() {
    }

    @At
    @Ok(value="beetl:/platform/sys/user/custom.html")
    @RequiresAuthentication
    public void custom() {
    }

    @At
    @Ok(value="beetl:/platform/sys/user/mode.html")
    @RequiresAuthentication
    public void mode() {
    }

    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object modeDo(@Param(value="mode") String mode, HttpServletRequest req) {
        try {
            this.sysUserService.update(Chain.make((String)"loginPjax", (Object)"true".equals(mode)), (Condition)Cnd.where((String)"id", (String)"=", (Object)req.getAttribute("uid")));
            Subject subject = SecurityUtils.getSubject();
            Sys_user user = (Sys_user)subject.getPrincipal();
            if ("true".equals(mode)) {
                user.setLoginPjax(true);
            } else {
                user.setLoginPjax(false);
            }
            this.sysUserService.deleteCache(user.getId());
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object customDo(@Param(value="ids") String ids, HttpServletRequest req) {
        try {
            this.sysUserService.update(Chain.make((String)"customMenu", (Object)ids), (Condition)Cnd.where((String)"id", (String)"=", (Object)StringUtil.getPlatformUid()));
            Subject subject = SecurityUtils.getSubject();
            Sys_user user = (Sys_user)subject.getPrincipal();
            if (!Strings.isBlank((CharSequence)ids)) {
                user.setCustomMenu(ids);
                user.setCustomMenus(this.sysMenuService.query((Condition)Cnd.where((String)"id", (String)"in", (Object)ids.split(","))));
            } else {
                user.setCustomMenu("");
                user.setCustomMenus(new ArrayList());
            }
            this.sysUserService.deleteCache(user.getId());
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At
    @Ok(value="json")
    @RequiresAuthentication
    public Object doChangePassword(@Param(value="oldPassword") String oldPassword, @Param(value="newPassword") String newPassword, HttpServletRequest req) {
        Subject subject = SecurityUtils.getSubject();
        Sys_user user = (Sys_user)subject.getPrincipal();
        String old = new Sha256Hash((Object)oldPassword, (Object)user.getSalt(), 1024).toHex();
        if (old.equals(user.getPassword())) {
            String salt = R.UU32();
            String hashedPasswordBase64 = new Sha256Hash((Object)newPassword, (Object)ByteSource.Util.bytes((String)salt), 1024).toHex();
            user.setSalt(salt);
            user.setPassword(hashedPasswordBase64);
            this.sysUserService.update(Chain.make((String)"salt", (Object)salt).add("password", (Object)hashedPasswordBase64), (Condition)Cnd.where((String)"id", (String)"=", (Object)user.getId()));
            this.sysUserService.deleteCache(user.getId());
            return Result.success((String)"\u4fee\u6539\u6210\u529f");
        }
        return Result.error((String)"\u539f\u5bc6\u7801\u4e0d\u6b63\u786e");
    }
}

