/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.cms;

import cn.wizzer.app.cms.modules.models.Cms_channel;
import cn.wizzer.app.cms.modules.models.Cms_site;
import cn.wizzer.app.cms.modules.services.CmsChannelService;
import cn.wizzer.app.cms.modules.services.CmsSiteService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import com.alibaba.dubbo.config.annotation.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/cms/channel"})
public class CmsChannelController {
    private static final Log log = Logs.get();
    @Inject
    @Reference
    private CmsChannelService cmsChannelService;
    @Inject
    @Reference
    private CmsSiteService cmsSiteService;

    @At(value={"", "/?"})
    @Ok(value="beetl:/platform/cms/channel/index.html")
    @RequiresPermissions(value={"cms.content.channel"})
    public void index(String siteid, HttpServletRequest req) {
        List siteList = this.cmsSiteService.query();
        if (Strings.isBlank((CharSequence)siteid) && siteList.size() > 0) {
            siteid = ((Cms_site)siteList.get(0)).getId();
        }
        Cnd cnd = Cnd.NEW();
        cnd.and("siteid", "=", (Object)Strings.sNull((Object)siteid));
        cnd.and((SqlExpression)Cnd.exps((String)"parentId", (String)"=", (Object)"").or("parentId", "is", null));
        cnd.asc("location").asc("path");
        req.setAttribute("list", (Object)this.cmsChannelService.query((Condition)cnd));
        req.setAttribute("siteList", (Object)siteList);
        req.setAttribute("siteid", (Object)Strings.sNull((Object)siteid));
    }

    @At(value={"/add/?"})
    @Ok(value="beetl:/platform/cms/channel/add.html")
    @RequiresPermissions(value={"cms.content.channel"})
    public Object add(String siteid, @Param(value="pid") String pid, HttpServletRequest req) {
        req.setAttribute("siteid", (Object)siteid);
        return Strings.isBlank((CharSequence)pid) ? null : this.cmsChannelService.fetch(pid);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel.add"})
    @SLog(tag="\u65b0\u5efa\u680f\u76ee", msg="\u680f\u76ee\u540d\u79f0:${args[0].name}")
    public Object addDo(@Param(value="..") Cms_channel channel, @Param(value="parentId") String parentId, HttpServletRequest req) {
        try {
            channel.setOpBy(StringUtil.getPlatformUid());
            this.cmsChannelService.save(channel, parentId);
            this.cmsChannelService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="beetl:/platform/cms/channel/edit.html")
    @RequiresPermissions(value={"cms.content.channel"})
    public Object edit(String id, HttpServletRequest req) {
        Cms_channel channel = (Cms_channel)this.cmsChannelService.fetch(id);
        if (channel != null) {
            req.setAttribute("parentMenu", this.cmsChannelService.fetch(channel.getParentId()));
            req.setAttribute("siteid", (Object)channel.getSiteid());
        }
        return channel;
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel.edit"})
    @SLog(tag="\u7f16\u8f91\u680f\u76ee", msg="\u680f\u76ee\u540d\u79f0:${args[0].name}")
    public Object editDo(@Param(value="..") Cms_channel channel, HttpServletRequest req) {
        try {
            channel.setOpBy(StringUtil.getPlatformUid());
            channel.setOpAt(Long.valueOf(Times.getTS()));
            this.cmsChannelService.updateIgnoreNull((Object)channel);
            this.cmsChannelService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel.delete"})
    @SLog(tag="\u5220\u9664\u680f\u76ee", msg="\u680f\u76ee\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object delete(String id, HttpServletRequest req) {
        try {
            Cms_channel channel = (Cms_channel)this.cmsChannelService.fetch(id);
            req.setAttribute("name", (Object)channel.getName());
            this.cmsChannelService.deleteAndChild(channel);
            this.cmsChannelService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel.edit"})
    @SLog(tag="\u542f\u7528\u680f\u76ee", msg="\u680f\u76ee\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object enable(String menuId, HttpServletRequest req) {
        try {
            req.setAttribute("name", (Object)((Cms_channel)this.cmsChannelService.fetch(menuId)).getName());
            this.cmsChannelService.update(Chain.make((String)"disabled", (Object)false), (Condition)Cnd.where((String)"id", (String)"=", (Object)menuId));
            this.cmsChannelService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel.edit"})
    @SLog(tag="\u7981\u7528\u680f\u76ee", msg="\u680f\u76ee\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object disable(String menuId, HttpServletRequest req) {
        try {
            req.setAttribute("name", (Object)((Cms_channel)this.cmsChannelService.fetch(menuId)).getName());
            this.cmsChannelService.update(Chain.make((String)"disabled", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)menuId));
            this.cmsChannelService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/tree/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel"})
    public Object tree(String siteid, @Param(value="pid") String pid) {
        List list = this.cmsChannelService.query((Condition)Cnd.where((String)"parentId", (String)"=", (Object)Strings.sBlank((Object)pid)).and("siteid", "=", (Object)siteid).asc("location").asc("path"));
        ArrayList tree = new ArrayList();
        for (Cms_channel channel : list) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("id", channel.getId());
            obj.put("text", channel.getName());
            obj.put("children", channel.isHasChildren());
            tree.add(obj);
        }
        return tree;
    }

    @At(value={"/child/?"})
    @Ok(value="beetl:/platform/cms/channel/child.html")
    @RequiresPermissions(value={"cms.content.channel"})
    public Object child(String id) {
        return this.cmsChannelService.query((Condition)Cnd.where((String)"parentId", (String)"=", (Object)id).asc("location").asc("path"));
    }

    @At(value={"/sort/?"})
    @Ok(value="beetl:/platform/cms/channel/sort.html")
    @RequiresPermissions(value={"cms.content.channel"})
    public void sort(String siteid, HttpServletRequest req) {
        List list = this.cmsChannelService.query((Condition)Cnd.where((String)"siteid", (String)"=", (Object)siteid).asc("location").asc("path"));
        ArrayList<Cms_channel> firstMenus = new ArrayList<Cms_channel>();
        HashMap<String, ArrayList<Cms_channel>> secondMenus = new HashMap<String, ArrayList<Cms_channel>>();
        for (Cms_channel menu : list) {
            if (menu.getPath().length() > 4) {
                ArrayList<Cms_channel> s = (ArrayList<Cms_channel>)secondMenus.get(StringUtil.getParentId(menu.getPath()));
                if (s == null) {
                    s = new ArrayList<Cms_channel>();
                }
                s.add(menu);
                secondMenus.put(StringUtil.getParentId(menu.getPath()), s);
                continue;
            }
            if (menu.getPath().length() != 4) continue;
            firstMenus.add(menu);
        }
        req.setAttribute("firstMenus", firstMenus);
        req.setAttribute("secondMenus", secondMenus);
        req.setAttribute("siteid", (Object)siteid);
        this.cmsChannelService.clearCache();
    }

    @At(value={"/sortDo/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"cms.content.channel.sort"})
    public Object sortDo(String siteid, @Param(value="ids") String ids, HttpServletRequest req) {
        try {
            String[] menuIds = StringUtils.split((String)ids, (String)",");
            int i = 0;
            this.cmsChannelService.dao().execute(Sqls.create((String)"update cms_channel set location=0 where siteid=@siteid").setParam("siteid", (Object)siteid));
            for (String s : menuIds) {
                if (Strings.isBlank((CharSequence)s)) continue;
                this.cmsChannelService.update(Chain.make((String)"location", (Object)i), (Condition)Cnd.where((String)"id", (String)"=", (Object)s));
                ++i;
            }
            this.cmsChannelService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }
}

